
package org.datacontract.schemas.radixx.connectpoint.reservation;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Response" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ViewImportPNR.Reservation.Segment.AirlinePerson">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:int" name="PersonOrgID"/>
 *     &lt;xs:element type="xs:int" name="TravelsWithPersonOrgID"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="FareClass"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="FareBasisCode"/>
 *     &lt;xs:element type="ns:ArrayOfViewImportPNR.Reservation.Segment.AirlinePerson.Charge" nillable="true" name="Charges"/>
 *     &lt;xs:element type="ns:ArrayOfViewImportPNR.Reservation.Segment.AirlinePerson.Seat" nillable="true" name="Seats"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ViewImportPNRReservationSegmentAirlinePerson
{
    private int personOrgID;
    private int travelsWithPersonOrgID;
    private String fareClass;
    private String fareBasisCode;
    private ArrayOfViewImportPNRReservationSegmentAirlinePersonCharge charges;
    private ArrayOfViewImportPNRReservationSegmentAirlinePersonSeat seats;

    /** 
     * Get the 'PersonOrgID' element value. 
    					Description: The automatically system generated unique identifier for the
    					passenger. Unless Performing a passenger Name Change then it will
    					be the personOrgID rendered from the ViewPNR Response.
    				Constraints: Optional (Not Required).
    				
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @return value
     */
    public int getPersonOrgID() {
        return personOrgID;
    }

    /** 
     * Set the 'PersonOrgID' element value. 
    					Description: The automatically system generated unique identifier for the
    					passenger. Unless Performing a passenger Name Change then it will
    					be the personOrgID rendered from the ViewPNR Response.
    				Constraints: Optional (Not Required).
    				
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @param personOrgID
     */
    public void setPersonOrgID(int personOrgID) {
        this.personOrgID = personOrgID;
    }

    /** 
     * Get the 'TravelsWithPersonOrgID' element value. 
    					Description: If an infant is traveling with an adult then the infants person
    					org id will be populated in this property.
    				Constraints: Optional (Not Required).
    				
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @return value
     */
    public int getTravelsWithPersonOrgID() {
        return travelsWithPersonOrgID;
    }

    /** 
     * Set the 'TravelsWithPersonOrgID' element value. 
    					Description: If an infant is traveling with an adult then the infants person
    					org id will be populated in this property.
    				Constraints: Optional (Not Required).
    				
    					Range: Value must be in the range -2147483648 and 2147483647.
    				
     * 
     * @param travelsWithPersonOrgID
     */
    public void setTravelsWithPersonOrgID(int travelsWithPersonOrgID) {
        this.travelsWithPersonOrgID = travelsWithPersonOrgID;
    }

    /** 
     * Get the 'FareClass' element value. 
    					Description: The fareclass that the segment was booked under..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 3.
    				Format: AlphaNumeric.
     * 
     * @return value
     */
    public String getFareClass() {
        return fareClass;
    }

    /** 
     * Set the 'FareClass' element value. 
    					Description: The fareclass that the segment was booked under..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 3.
    				Format: AlphaNumeric.
     * 
     * @param fareClass
     */
    public void setFareClass(String fareClass) {
        this.fareClass = fareClass;
    }

    /** 
     * Get the 'FareBasisCode' element value. 
    					Description: The fareclass that the segment was booked under..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 3.
    				Format: AlphaNumeric.
     * 
     * @return value
     */
    public String getFareBasisCode() {
        return fareBasisCode;
    }

    /** 
     * Set the 'FareBasisCode' element value. 
    					Description: The fareclass that the segment was booked under..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 3.
    				Format: AlphaNumeric.
     * 
     * @param fareBasisCode
     */
    public void setFareBasisCode(String fareBasisCode) {
        this.fareBasisCode = fareBasisCode;
    }

    /** 
     * Get the 'Charges' element value. Description: The collection of Charges.
    				Constraints: Optional (Not Required).
    				Range: Value must be in the range 0 and 99.
    				
     * 
     * @return value
     */
    public ArrayOfViewImportPNRReservationSegmentAirlinePersonCharge getCharges() {
        return charges;
    }

    /** 
     * Set the 'Charges' element value. Description: The collection of Charges.
    				Constraints: Optional (Not Required).
    				Range: Value must be in the range 0 and 99.
    				
     * 
     * @param charges
     */
    public void setCharges(
            ArrayOfViewImportPNRReservationSegmentAirlinePersonCharge charges) {
        this.charges = charges;
    }

    /** 
     * Get the 'Seats' element value.
     * 
     * @return value
     */
    public ArrayOfViewImportPNRReservationSegmentAirlinePersonSeat getSeats() {
        return seats;
    }

    /** 
     * Set the 'Seats' element value.
     * 
     * @param seats
     */
    public void setSeats(
            ArrayOfViewImportPNRReservationSegmentAirlinePersonSeat seats) {
        this.seats = seats;
    }
}
