
package org.datacontract.schemas.radixx.connectpoint.reservation;

import java.math.BigDecimal;
import org.datacontract.schemas.radixx.connectpoint.EnumerationsCurrencyCodeTypes;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Reservation.Response" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ViewImportPNR.Reservation.Segment.AirlinePerson.Charge">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" nillable="true" name="CodeType"/>
 *     &lt;xs:element type="xs:decimal" name="Amount"/>
 *     &lt;xs:element type="ns:Enumerations.CurrencyCodeTypes" name="Currency"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ViewImportPNRReservationSegmentAirlinePersonCharge
{
    private String codeType;
    private BigDecimal amount;
    private EnumerationsCurrencyCodeTypes currency;

    /** 
     * Get the 'CodeType' element value. 
    					Description: The Code Type Represents the category for this charge.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 6.
    				
     * 
     * @return value
     */
    public String getCodeType() {
        return codeType;
    }

    /** 
     * Set the 'CodeType' element value. 
    					Description: The Code Type Represents the category for this charge.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 6.
    				
     * 
     * @param codeType
     */
    public void setCodeType(String codeType) {
        this.codeType = codeType;
    }

    /** 
     * Get the 'Amount' element value. Description: Amount of the SSR.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public BigDecimal getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. Description: Amount of the SSR.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param amount
     */
    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'Currency' element value. 
    					Description: Currency of the reservation and the SSR charge.
    				Constraints: Optional (Not Required).
    				
     * 
     * @return value
     */
    public EnumerationsCurrencyCodeTypes getCurrency() {
        return currency;
    }

    /** 
     * Set the 'Currency' element value. 
    					Description: Currency of the reservation and the SSR charge.
    				Constraints: Optional (Not Required).
    				
     * 
     * @param currency
     */
    public void setCurrency(EnumerationsCurrencyCodeTypes currency) {
        this.currency = currency;
    }
}
