
package org.datacontract.schemas.radixx.connectpoint.travelagents;

import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.TravelAgents.Response" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AgencyCreditCardInfo">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" nillable="true" name="AccountNumber"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="AccountName"/>
 *     &lt;xs:element type="xs:dateTime" name="AccountExpirationDate"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AgencyCreditCardInfo
{
    private String accountNumber;
    private String accountName;
    private Date accountExpirationDate;

    /** 
     * Get the 'AccountNumber' element value. 
    					Description: Credit Card Number associated with this Credit Card.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getAccountNumber() {
        return accountNumber;
    }

    /** 
     * Set the 'AccountNumber' element value. 
    					Description: Credit Card Number associated with this Credit Card.
    				Constraints: Required.
     * 
     * @param accountNumber
     */
    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    /** 
     * Get the 'AccountName' element value. 
    					Description: Account Name associated with this Credit Card.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getAccountName() {
        return accountName;
    }

    /** 
     * Set the 'AccountName' element value. 
    					Description: Account Name associated with this Credit Card.
    				Constraints: Required.
     * 
     * @param accountName
     */
    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    /** 
     * Get the 'AccountExpirationDate' element value. 
    					Description: The Expiration Date associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @return value
     */
    public Date getAccountExpirationDate() {
        return accountExpirationDate;
    }

    /** 
     * Set the 'AccountExpirationDate' element value. 
    					Description: The Expiration Date associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @param accountExpirationDate
     */
    public void setAccountExpirationDate(Date accountExpirationDate) {
        this.accountExpirationDate = accountExpirationDate;
    }
}
