
package org.datacontract.schemas.radixx.connectpoint.travelagents;

import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.TravelAgents.Response" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AgencyPNR">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" nillable="true" name="SeriesNumber"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ConfirmationNumber"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="FirstName"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="LastName"/>
 *     &lt;xs:element type="xs:dateTime" name="BookDate"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Email"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Adress1"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="PaymentReferenceNumber" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AgencyPNR
{
    private String seriesNumber;
    private String confirmationNumber;
    private String firstName;
    private String lastName;
    private Date bookDate;
    private String email;
    private String adress1;
    private String paymentReferenceNumber;

    /** 
     * Get the 'SeriesNumber' element value. 
    					Description: The series number for this reservation. For now always '299'.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getSeriesNumber() {
        return seriesNumber;
    }

    /** 
     * Set the 'SeriesNumber' element value. 
    					Description: The series number for this reservation. For now always '299'.
    				Constraints: Required.
     * 
     * @param seriesNumber
     */
    public void setSeriesNumber(String seriesNumber) {
        this.seriesNumber = seriesNumber;
    }

    /** 
     * Get the 'ConfirmationNumber' element value. 
    					Description: The system-generated confirmation number that is used to uniquely
    					identify a reservation in the Radixx system.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getConfirmationNumber() {
        return confirmationNumber;
    }

    /** 
     * Set the 'ConfirmationNumber' element value. 
    					Description: The system-generated confirmation number that is used to uniquely
    					identify a reservation in the Radixx system.
    				Constraints: Required.
     * 
     * @param confirmationNumber
     */
    public void setConfirmationNumber(String confirmationNumber) {
        this.confirmationNumber = confirmationNumber;
    }

    /** 
     * Get the 'FirstName' element value. 
    					Description: The firstname of the primary passenger.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getFirstName() {
        return firstName;
    }

    /** 
     * Set the 'FirstName' element value. 
    					Description: The firstname of the primary passenger.
    				Constraints: Required.
     * 
     * @param firstName
     */
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    /** 
     * Get the 'LastName' element value. 
    					Description: The lastname of the primary passenger.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getLastName() {
        return lastName;
    }

    /** 
     * Set the 'LastName' element value. 
    					Description: The lastname of the primary passenger.
    				Constraints: Required.
     * 
     * @param lastName
     */
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    /** 
     * Get the 'BookDate' element value. 
    					Description: The date/time this reservation was created in the system, in GMT.
    				Constraints: Required.
     * 
     * @return value
     */
    public Date getBookDate() {
        return bookDate;
    }

    /** 
     * Set the 'BookDate' element value. 
    					Description: The date/time this reservation was created in the system, in GMT.
    				Constraints: Required.
     * 
     * @param bookDate
     */
    public void setBookDate(Date bookDate) {
        this.bookDate = bookDate;
    }

    /** 
     * Get the 'Email' element value. Description: The Email for the primary passenger.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getEmail() {
        return email;
    }

    /** 
     * Set the 'Email' element value. Description: The Email for the primary passenger.
    				Constraints: Required.
     * 
     * @param email
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /** 
     * Get the 'Adress1' element value. 
    					Description: The first address for the primary passenger.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getAdress1() {
        return adress1;
    }

    /** 
     * Set the 'Adress1' element value. 
    					Description: The first address for the primary passenger.
    				Constraints: Required.
     * 
     * @param adress1
     */
    public void setAdress1(String adress1) {
        this.adress1 = adress1;
    }

    /** 
     * Get the 'PaymentReferenceNumber' element value. Description: Payment reference number.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 10.
    				
     * 
     * @return value
     */
    public String getPaymentReferenceNumber() {
        return paymentReferenceNumber;
    }

    /** 
     * Set the 'PaymentReferenceNumber' element value. Description: Payment reference number.
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 10.
    				
     * 
     * @param paymentReferenceNumber
     */
    public void setPaymentReferenceNumber(String paymentReferenceNumber) {
        this.paymentReferenceNumber = paymentReferenceNumber;
    }
}
