
package org.datacontract.schemas.radixx.connectpoint.travelagents;

import org.datacontract.schemas.radixx.connectpoint.EnumerationsTravelAgencyTypes;
import org.datacontract.schemas.radixx.connectpoint.TransactionInfo;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.TravelAgents.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CreateAgency">
 *   &lt;xs:complexContent mixed="false">
 *     &lt;xs:extension base="ns1:TransactionInfo">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:CreateAgency.ActionTypes" name="ActionType"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="IATANumber"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="AgencyName"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="AgencyAdress1"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="AgencyAdress2"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="AgencyCity"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="AgencyState"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="AgencyCurrency"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="LegalName"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="AgencyPostalCode"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="AgencyCountry"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="ContactName"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="AccountFirstName"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="AccountLastName"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="AccountEmail"/>
 *         &lt;xs:element type="ns:ArrayOfTAContactInfo" nillable="true" name="ContactInfos"/>
 *         &lt;xs:element type="xs:int" name="NumberOfBranches"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="AgencyWebSiteUrl"/>
 *         &lt;xs:element type="xs:int" name="AgencyCreditLimit"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="AgencyCreditLimitCurrency"/>
 *         &lt;xs:element type="xs:boolean" name="AgencyFetExempt"/>
 *         &lt;xs:element type="xs:boolean" name="PreferrEmailReceipt"/>
 *         &lt;xs:element type="xs:boolean" name="PreferrFaxReceipt"/>
 *         &lt;xs:element type="xs:boolean" name="PreferrMailReceipt"/>
 *         &lt;xs:element type="ns1:Enumerations.TravelAgencyTypes" name="AgencyType"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="AccountUserName"/>
 *         &lt;xs:element type="xs:int" name="AgencyRegion"/>
 *         &lt;xs:element type="xs:boolean" name="UseParentCreditLimit"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="LanguageCode"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CreateAgency extends TransactionInfo
{
    private CreateAgencyActionTypes actionType;
    private String IATANumber;
    private String agencyName;
    private String agencyAdress1;
    private String agencyAdress2;
    private String agencyCity;
    private String agencyState;
    private String agencyCurrency;
    private String legalName;
    private String agencyPostalCode;
    private String agencyCountry;
    private String contactName;
    private String accountFirstName;
    private String accountLastName;
    private String accountEmail;
    private ArrayOfTAContactInfo contactInfos;
    private int numberOfBranches;
    private String agencyWebSiteUrl;
    private int agencyCreditLimit;
    private String agencyCreditLimitCurrency;
    private boolean agencyFetExempt;
    private boolean preferrEmailReceipt;
    private boolean preferrFaxReceipt;
    private boolean preferrMailReceipt;
    private EnumerationsTravelAgencyTypes agencyType;
    private String accountUserName;
    private int agencyRegion;
    private boolean useParentCreditLimit;
    private String languageCode;

    /** 
     * Get the 'ActionType' element value. 
    							Description: Action type indicating the option to add parent or child travel
    							agency.
    						Constraints: Required.
     * 
     * @return value
     */
    public CreateAgencyActionTypes getActionType() {
        return actionType;
    }

    /** 
     * Set the 'ActionType' element value. 
    							Description: Action type indicating the option to add parent or child travel
    							agency.
    						Constraints: Required.
     * 
     * @param actionType
     */
    public void setActionType(CreateAgencyActionTypes actionType) {
        this.actionType = actionType;
    }

    /** 
     * Get the 'IATANumber' element value. 
    							Description: The IATA Number for the travel agency.
    						Constraints: Required.Range: Length must be in the range 1 and 8.
    						Format: AlphaNumericCodeMixedDotDash.
    						
     * 
     * @return value
     */
    public String getIATANumber() {
        return IATANumber;
    }

    /** 
     * Set the 'IATANumber' element value. 
    							Description: The IATA Number for the travel agency.
    						Constraints: Required.Range: Length must be in the range 1 and 8.
    						Format: AlphaNumericCodeMixedDotDash.
    						
     * 
     * @param IATANumber
     */
    public void setIATANumber(String IATANumber) {
        this.IATANumber = IATANumber;
    }

    /** 
     * Get the 'AgencyName' element value. Description: The Travel Agency Name.
    						Constraints: Required.Range: Length must be in the range 1 and 100.
    						
     * 
     * @return value
     */
    public String getAgencyName() {
        return agencyName;
    }

    /** 
     * Set the 'AgencyName' element value. Description: The Travel Agency Name.
    						Constraints: Required.Range: Length must be in the range 1 and 100.
    						
     * 
     * @param agencyName
     */
    public void setAgencyName(String agencyName) {
        this.agencyName = agencyName;
    }

    /** 
     * Get the 'AgencyAdress1' element value. Description: The Travel Agency Address1.
    						Constraints: Required.Range: Length must be in the range 1 and 100.
    						
     * 
     * @return value
     */
    public String getAgencyAdress1() {
        return agencyAdress1;
    }

    /** 
     * Set the 'AgencyAdress1' element value. Description: The Travel Agency Address1.
    						Constraints: Required.Range: Length must be in the range 1 and 100.
    						
     * 
     * @param agencyAdress1
     */
    public void setAgencyAdress1(String agencyAdress1) {
        this.agencyAdress1 = agencyAdress1;
    }

    /** 
     * Get the 'AgencyAdress2' element value. Description: The Travel Agency Address2.
    						Constraints: Required.Range: Length must be in the range 1 and 100.
    						
     * 
     * @return value
     */
    public String getAgencyAdress2() {
        return agencyAdress2;
    }

    /** 
     * Set the 'AgencyAdress2' element value. Description: The Travel Agency Address2.
    						Constraints: Required.Range: Length must be in the range 1 and 100.
    						
     * 
     * @param agencyAdress2
     */
    public void setAgencyAdress2(String agencyAdress2) {
        this.agencyAdress2 = agencyAdress2;
    }

    /** 
     * Get the 'AgencyCity' element value. Description: The Travel Agency City.
    						Constraints: Required.Range: Length must be in the range 1 and 50.
    						
     * 
     * @return value
     */
    public String getAgencyCity() {
        return agencyCity;
    }

    /** 
     * Set the 'AgencyCity' element value. Description: The Travel Agency City.
    						Constraints: Required.Range: Length must be in the range 1 and 50.
    						
     * 
     * @param agencyCity
     */
    public void setAgencyCity(String agencyCity) {
        this.agencyCity = agencyCity;
    }

    /** 
     * Get the 'AgencyState' element value. Description: The Travel Agency State.
    						Constraints: Required.Range: Length must be in the range 1 and 64.
    						
     * 
     * @return value
     */
    public String getAgencyState() {
        return agencyState;
    }

    /** 
     * Set the 'AgencyState' element value. Description: The Travel Agency State.
    						Constraints: Required.Range: Length must be in the range 1 and 64.
    						
     * 
     * @param agencyState
     */
    public void setAgencyState(String agencyState) {
        this.agencyState = agencyState;
    }

    /** 
     * Get the 'AgencyCurrency' element value. Description: The Travel Agency Currency.
    						Constraints: Required.Range: Length must be in the range 1 and 3.
    						
     * 
     * @return value
     */
    public String getAgencyCurrency() {
        return agencyCurrency;
    }

    /** 
     * Set the 'AgencyCurrency' element value. Description: The Travel Agency Currency.
    						Constraints: Required.Range: Length must be in the range 1 and 3.
    						
     * 
     * @param agencyCurrency
     */
    public void setAgencyCurrency(String agencyCurrency) {
        this.agencyCurrency = agencyCurrency;
    }

    /** 
     * Get the 'LegalName' element value. Description: The Travel Agency Lagel name.
    						Constraints: Required.Range: Length must be in the range 1 and 64.
    						
     * 
     * @return value
     */
    public String getLegalName() {
        return legalName;
    }

    /** 
     * Set the 'LegalName' element value. Description: The Travel Agency Lagel name.
    						Constraints: Required.Range: Length must be in the range 1 and 64.
    						
     * 
     * @param legalName
     */
    public void setLegalName(String legalName) {
        this.legalName = legalName;
    }

    /** 
     * Get the 'AgencyPostalCode' element value. Description: The Travel Agency post code.
    						Constraints: Required.Range: Length must be in the range 1 and 10.
    						
     * 
     * @return value
     */
    public String getAgencyPostalCode() {
        return agencyPostalCode;
    }

    /** 
     * Set the 'AgencyPostalCode' element value. Description: The Travel Agency post code.
    						Constraints: Required.Range: Length must be in the range 1 and 10.
    						
     * 
     * @param agencyPostalCode
     */
    public void setAgencyPostalCode(String agencyPostalCode) {
        this.agencyPostalCode = agencyPostalCode;
    }

    /** 
     * Get the 'AgencyCountry' element value. Description: The Travel Agency country.
    						Constraints: Required.Range: Length must be in the range 1 and 30.
    						
     * 
     * @return value
     */
    public String getAgencyCountry() {
        return agencyCountry;
    }

    /** 
     * Set the 'AgencyCountry' element value. Description: The Travel Agency country.
    						Constraints: Required.Range: Length must be in the range 1 and 30.
    						
     * 
     * @param agencyCountry
     */
    public void setAgencyCountry(String agencyCountry) {
        this.agencyCountry = agencyCountry;
    }

    /** 
     * Get the 'ContactName' element value. Description: The Travel Agency contact name.
    						Constraints: Required.Range: Length must be in the range 1 and 64.
    						
     * 
     * @return value
     */
    public String getContactName() {
        return contactName;
    }

    /** 
     * Set the 'ContactName' element value. Description: The Travel Agency contact name.
    						Constraints: Required.Range: Length must be in the range 1 and 64.
    						
     * 
     * @param contactName
     */
    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    /** 
     * Get the 'AccountFirstName' element value. Description: The Travel Agency Name.
    						Constraints: Required.Range: Length must be in the range 1 and 64.
    						
     * 
     * @return value
     */
    public String getAccountFirstName() {
        return accountFirstName;
    }

    /** 
     * Set the 'AccountFirstName' element value. Description: The Travel Agency Name.
    						Constraints: Required.Range: Length must be in the range 1 and 64.
    						
     * 
     * @param accountFirstName
     */
    public void setAccountFirstName(String accountFirstName) {
        this.accountFirstName = accountFirstName;
    }

    /** 
     * Get the 'AccountLastName' element value. Description: The Travel Agency Name.
    						Constraints: Required.Range: Length must be in the range 1 and 64.
    						
     * 
     * @return value
     */
    public String getAccountLastName() {
        return accountLastName;
    }

    /** 
     * Set the 'AccountLastName' element value. Description: The Travel Agency Name.
    						Constraints: Required.Range: Length must be in the range 1 and 64.
    						
     * 
     * @param accountLastName
     */
    public void setAccountLastName(String accountLastName) {
        this.accountLastName = accountLastName;
    }

    /** 
     * Get the 'AccountEmail' element value. Description: The Travel Agency account email.
    						Constraints: Required.Range: Length must be in the range 1 and 150.
    						
     * 
     * @return value
     */
    public String getAccountEmail() {
        return accountEmail;
    }

    /** 
     * Set the 'AccountEmail' element value. Description: The Travel Agency account email.
    						Constraints: Required.Range: Length must be in the range 1 and 150.
    						
     * 
     * @param accountEmail
     */
    public void setAccountEmail(String accountEmail) {
        this.accountEmail = accountEmail;
    }

    /** 
     * Get the 'ContactInfos' element value. Description: Collection of Contact Info.
    						Constraints: Optional (Not Required).
    						
    							Range: Value must be in the range 0 and 2147483647.
    						
     * 
     * @return value
     */
    public ArrayOfTAContactInfo getContactInfos() {
        return contactInfos;
    }

    /** 
     * Set the 'ContactInfos' element value. Description: Collection of Contact Info.
    						Constraints: Optional (Not Required).
    						
    							Range: Value must be in the range 0 and 2147483647.
    						
     * 
     * @param contactInfos
     */
    public void setContactInfos(ArrayOfTAContactInfo contactInfos) {
        this.contactInfos = contactInfos;
    }

    /** 
     * Get the 'NumberOfBranches' element value. Description: The Travel Agency number of
    							branches.Constraints: Required.
     * 
     * @return value
     */
    public int getNumberOfBranches() {
        return numberOfBranches;
    }

    /** 
     * Set the 'NumberOfBranches' element value. Description: The Travel Agency number of
    							branches.Constraints: Required.
     * 
     * @param numberOfBranches
     */
    public void setNumberOfBranches(int numberOfBranches) {
        this.numberOfBranches = numberOfBranches;
    }

    /** 
     * Get the 'AgencyWebSiteUrl' element value. Description: The Travel Agency website url.
    						Constraints: Required.
     * 
     * @return value
     */
    public String getAgencyWebSiteUrl() {
        return agencyWebSiteUrl;
    }

    /** 
     * Set the 'AgencyWebSiteUrl' element value. Description: The Travel Agency website url.
    						Constraints: Required.
     * 
     * @param agencyWebSiteUrl
     */
    public void setAgencyWebSiteUrl(String agencyWebSiteUrl) {
        this.agencyWebSiteUrl = agencyWebSiteUrl;
    }

    /** 
     * Get the 'AgencyCreditLimit' element value. Description: Travel Agency credit limit.
    						Constraints: Required.
     * 
     * @return value
     */
    public int getAgencyCreditLimit() {
        return agencyCreditLimit;
    }

    /** 
     * Set the 'AgencyCreditLimit' element value. Description: Travel Agency credit limit.
    						Constraints: Required.
     * 
     * @param agencyCreditLimit
     */
    public void setAgencyCreditLimit(int agencyCreditLimit) {
        this.agencyCreditLimit = agencyCreditLimit;
    }

    /** 
     * Get the 'AgencyCreditLimitCurrency' element value. Description: Travel Agency credit limit
    							currency.Constraints: Required.
     * 
     * @return value
     */
    public String getAgencyCreditLimitCurrency() {
        return agencyCreditLimitCurrency;
    }

    /** 
     * Set the 'AgencyCreditLimitCurrency' element value. Description: Travel Agency credit limit
    							currency.Constraints: Required.
     * 
     * @param agencyCreditLimitCurrency
     */
    public void setAgencyCreditLimitCurrency(String agencyCreditLimitCurrency) {
        this.agencyCreditLimitCurrency = agencyCreditLimitCurrency;
    }

    /** 
     * Get the 'AgencyFetExempt' element value. Description: Travel Agency FetExempt.
    						Constraints: Required.
     * 
     * @return value
     */
    public boolean isAgencyFetExempt() {
        return agencyFetExempt;
    }

    /** 
     * Set the 'AgencyFetExempt' element value. Description: Travel Agency FetExempt.
    						Constraints: Required.
     * 
     * @param agencyFetExempt
     */
    public void setAgencyFetExempt(boolean agencyFetExempt) {
        this.agencyFetExempt = agencyFetExempt;
    }

    /** 
     * Get the 'PreferrEmailReceipt' element value. Description: Travel Agency Preferr email
    							receipt.Constraints: Required.
     * 
     * @return value
     */
    public boolean isPreferrEmailReceipt() {
        return preferrEmailReceipt;
    }

    /** 
     * Set the 'PreferrEmailReceipt' element value. Description: Travel Agency Preferr email
    							receipt.Constraints: Required.
     * 
     * @param preferrEmailReceipt
     */
    public void setPreferrEmailReceipt(boolean preferrEmailReceipt) {
        this.preferrEmailReceipt = preferrEmailReceipt;
    }

    /** 
     * Get the 'PreferrFaxReceipt' element value. Description: Travel Agency Preferr fax receipt.
    						Constraints: Required.
     * 
     * @return value
     */
    public boolean isPreferrFaxReceipt() {
        return preferrFaxReceipt;
    }

    /** 
     * Set the 'PreferrFaxReceipt' element value. Description: Travel Agency Preferr fax receipt.
    						Constraints: Required.
     * 
     * @param preferrFaxReceipt
     */
    public void setPreferrFaxReceipt(boolean preferrFaxReceipt) {
        this.preferrFaxReceipt = preferrFaxReceipt;
    }

    /** 
     * Get the 'PreferrMailReceipt' element value. Description: Travel Agency Preferr mail
    							receipt.Constraints: Required.
     * 
     * @return value
     */
    public boolean isPreferrMailReceipt() {
        return preferrMailReceipt;
    }

    /** 
     * Set the 'PreferrMailReceipt' element value. Description: Travel Agency Preferr mail
    							receipt.Constraints: Required.
     * 
     * @param preferrMailReceipt
     */
    public void setPreferrMailReceipt(boolean preferrMailReceipt) {
        this.preferrMailReceipt = preferrMailReceipt;
    }

    /** 
     * Get the 'AgencyType' element value. Description: Travel Agency Type.
    						Constraints: Required.
     * 
     * @return value
     */
    public EnumerationsTravelAgencyTypes getAgencyType() {
        return agencyType;
    }

    /** 
     * Set the 'AgencyType' element value. Description: Travel Agency Type.
    						Constraints: Required.
     * 
     * @param agencyType
     */
    public void setAgencyType(EnumerationsTravelAgencyTypes agencyType) {
        this.agencyType = agencyType;
    }

    /** 
     * Get the 'AccountUserName' element value. Description: Travel Agency Username.
    						Constraints: Required.Range: Length must be in the range 1 and 15.
    						
     * 
     * @return value
     */
    public String getAccountUserName() {
        return accountUserName;
    }

    /** 
     * Set the 'AccountUserName' element value. Description: Travel Agency Username.
    						Constraints: Required.Range: Length must be in the range 1 and 15.
    						
     * 
     * @param accountUserName
     */
    public void setAccountUserName(String accountUserName) {
        this.accountUserName = accountUserName;
    }

    /** 
     * Get the 'AgencyRegion' element value. Description: Travel Agency Region.
    						Constraints: Required.
     * 
     * @return value
     */
    public int getAgencyRegion() {
        return agencyRegion;
    }

    /** 
     * Set the 'AgencyRegion' element value. Description: Travel Agency Region.
    						Constraints: Required.
     * 
     * @param agencyRegion
     */
    public void setAgencyRegion(int agencyRegion) {
        this.agencyRegion = agencyRegion;
    }

    /** 
     * Get the 'UseParentCreditLimit' element value. 
    							Description: Travel Agency has shared credit limit.
    						Constraints: Required.
     * 
     * @return value
     */
    public boolean isUseParentCreditLimit() {
        return useParentCreditLimit;
    }

    /** 
     * Set the 'UseParentCreditLimit' element value. 
    							Description: Travel Agency has shared credit limit.
    						Constraints: Required.
     * 
     * @param useParentCreditLimit
     */
    public void setUseParentCreditLimit(boolean useParentCreditLimit) {
        this.useParentCreditLimit = useParentCreditLimit;
    }

    /** 
     * Get the 'LanguageCode' element value. Description: The Travel Agency Name.
    						Constraints: Required.
     * 
     * @return value
     */
    public String getLanguageCode() {
        return languageCode;
    }

    /** 
     * Set the 'LanguageCode' element value. Description: The Travel Agency Name.
    						Constraints: Required.
     * 
     * @param languageCode
     */
    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }
}
