
package org.datacontract.schemas.radixx.connectpoint.travelagents;

import java.math.BigDecimal;
import org.datacontract.schemas.radixx.connectpoint.TransactionInfo;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.TravelAgents.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ModifyAgencyCreditLimit">
 *   &lt;xs:complexContent mixed="false">
 *     &lt;xs:extension base="ns1:TransactionInfo">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" nillable="true" name="IATANumber" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="LoggedOnIATANumber" minOccurs="0"/>
 *         &lt;xs:element type="xs:decimal" name="NewCreditLimit" minOccurs="0"/>
 *         &lt;xs:element type="xs:decimal" name="OriginalCreditLimit" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="OriginalCurrency" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ModifyAgencyCreditLimit extends TransactionInfo
{
    private String IATANumber;
    private String loggedOnIATANumber;
    private BigDecimal newCreditLimit;
    private BigDecimal originalCreditLimit;
    private String originalCurrency;

    /** 
     * Get the 'IATANumber' element value. 
    							Description: The IATA Number that is having the credit limti adjusted..
    						Constraints: Required.Range: Length must be in the range 1 and 8.
    						Format: AlphaNumericCodeMixedDotDash.
    						
     * 
     * @return value
     */
    public String getIATANumber() {
        return IATANumber;
    }

    /** 
     * Set the 'IATANumber' element value. 
    							Description: The IATA Number that is having the credit limti adjusted..
    						Constraints: Required.Range: Length must be in the range 1 and 8.
    						Format: AlphaNumericCodeMixedDotDash.
    						
     * 
     * @param IATANumber
     */
    public void setIATANumber(String IATANumber) {
        this.IATANumber = IATANumber;
    }

    /** 
     * Get the 'LoggedOnIATANumber' element value. 
    							Description: The Logged in IATA Number that is performing the credit limti
    							adjustment..
    						Constraints: Required.Range: Length must be in the range 1 and 8.
    						Format: AlphaNumericCodeMixedDotDash.
    						
     * 
     * @return value
     */
    public String getLoggedOnIATANumber() {
        return loggedOnIATANumber;
    }

    /** 
     * Set the 'LoggedOnIATANumber' element value. 
    							Description: The Logged in IATA Number that is performing the credit limti
    							adjustment..
    						Constraints: Required.Range: Length must be in the range 1 and 8.
    						Format: AlphaNumericCodeMixedDotDash.
    						
     * 
     * @param loggedOnIATANumber
     */
    public void setLoggedOnIATANumber(String loggedOnIATANumber) {
        this.loggedOnIATANumber = loggedOnIATANumber;
    }

    /** 
     * Get the 'NewCreditLimit' element value. 
    						Constraints: Required.
     * 
     * @return value
     */
    public BigDecimal getNewCreditLimit() {
        return newCreditLimit;
    }

    /** 
     * Set the 'NewCreditLimit' element value. 
    						Constraints: Required.
     * 
     * @param newCreditLimit
     */
    public void setNewCreditLimit(BigDecimal newCreditLimit) {
        this.newCreditLimit = newCreditLimit;
    }

    /** 
     * Get the 'OriginalCreditLimit' element value. 
    						Constraints: Required.
     * 
     * @return value
     */
    public BigDecimal getOriginalCreditLimit() {
        return originalCreditLimit;
    }

    /** 
     * Set the 'OriginalCreditLimit' element value. 
    						Constraints: Required.
     * 
     * @param originalCreditLimit
     */
    public void setOriginalCreditLimit(BigDecimal originalCreditLimit) {
        this.originalCreditLimit = originalCreditLimit;
    }

    /** 
     * Get the 'OriginalCurrency' element value. 
    						Constraints: Required.
     * 
     * @return value
     */
    public String getOriginalCurrency() {
        return originalCurrency;
    }

    /** 
     * Set the 'OriginalCurrency' element value. 
    						Constraints: Required.
     * 
     * @param originalCurrency
     */
    public void setOriginalCurrency(String originalCurrency) {
        this.originalCurrency = originalCurrency;
    }
}
