
package org.datacontract.schemas.radixx.connectpoint.travelagents;

import java.util.Date;
import org.datacontract.schemas.radixx.connectpoint.EnumerationsAnswerTypes;
import org.datacontract.schemas.radixx.connectpoint.EnumerationsPNRStatus;
import org.datacontract.schemas.radixx.connectpoint.TransactionInfo;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.TravelAgents.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RetrieveBookingHistory">
 *   &lt;xs:complexContent mixed="false">
 *     &lt;xs:extension base="ns1:TransactionInfo">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:dateTime" name="BookingDateFrom" minOccurs="0"/>
 *         &lt;xs:element type="xs:dateTime" name="BookingDateTo" minOccurs="0"/>
 *         &lt;xs:element type="ns1:Enumerations.PNRStatus" name="BookingType" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="IATA" minOccurs="0"/>
 *         &lt;xs:element type="ns1:Enumerations.AnswerTypes" name="IncludeChildAgency" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RetrieveBookingHistory extends TransactionInfo
{
    private Date bookingDateFrom;
    private Date bookingDateTo;
    private EnumerationsPNRStatus bookingType;
    private String IATA;
    private EnumerationsAnswerTypes includeChildAgency;

    /** 
     * Get the 'BookingDateFrom' element value. Description: Booking creation from date.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Date getBookingDateFrom() {
        return bookingDateFrom;
    }

    /** 
     * Set the 'BookingDateFrom' element value. Description: Booking creation from date.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param bookingDateFrom
     */
    public void setBookingDateFrom(Date bookingDateFrom) {
        this.bookingDateFrom = bookingDateFrom;
    }

    /** 
     * Get the 'BookingDateTo' element value. Description: Booking creation to date.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Date getBookingDateTo() {
        return bookingDateTo;
    }

    /** 
     * Set the 'BookingDateTo' element value. Description: Booking creation to date.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param bookingDateTo
     */
    public void setBookingDateTo(Date bookingDateTo) {
        this.bookingDateTo = bookingDateTo;
    }

    /** 
     * Get the 'BookingType' element value. Description: All Bookings, Confirmed,
    							Payment,....Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public EnumerationsPNRStatus getBookingType() {
        return bookingType;
    }

    /** 
     * Set the 'BookingType' element value. Description: All Bookings, Confirmed,
    							Payment,....Constraints: Optional (Not Required).
    						
     * 
     * @param bookingType
     */
    public void setBookingType(EnumerationsPNRStatus bookingType) {
        this.bookingType = bookingType;
    }

    /** 
     * Get the 'IATA' element value. Description: IATA.Constraints: Optional (Not Required).
    						Range: Length must be in the range 1 and 8.
    						Format: AlphaNumericCodeMixedDotDash.
    						
     * 
     * @return value
     */
    public String getIATA() {
        return IATA;
    }

    /** 
     * Set the 'IATA' element value. Description: IATA.Constraints: Optional (Not Required).
    						Range: Length must be in the range 1 and 8.
    						Format: AlphaNumericCodeMixedDotDash.
    						
     * 
     * @param IATA
     */
    public void setIATA(String IATA) {
        this.IATA = IATA;
    }

    /** 
     * Get the 'IncludeChildAgency' element value. Description: Include child agency.
    						Constraints: Required.
     * 
     * @return value
     */
    public EnumerationsAnswerTypes getIncludeChildAgency() {
        return includeChildAgency;
    }

    /** 
     * Set the 'IncludeChildAgency' element value. Description: Include child agency.
    						Constraints: Required.
     * 
     * @param includeChildAgency
     */
    public void setIncludeChildAgency(EnumerationsAnswerTypes includeChildAgency) {
        this.includeChildAgency = includeChildAgency;
    }
}
