
package org.datacontract.schemas.radixx.connectpoint.travelagents;

import java.util.Date;
import org.datacontract.schemas.radixx.connectpoint.ArrayOfEnumerationsAgencyFields;
import org.datacontract.schemas.radixx.connectpoint.TransactionInfo;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.TravelAgents.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RetrieveChangedTAData">
 *   &lt;xs:complexContent mixed="false">
 *     &lt;xs:extension base="ns1:TransactionInfo">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:dateTime" name="DateFrom" minOccurs="0"/>
 *         &lt;xs:element type="xs:dateTime" name="DateTo" minOccurs="0"/>
 *         &lt;xs:element type="ns1:ArrayOfEnumerations.AgencyFields" nillable="true" name="OutputFields" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RetrieveChangedTAData extends TransactionInfo
{
    private Date dateFrom;
    private Date dateTo;
    private ArrayOfEnumerationsAgencyFields outputFields;

    /** 
     * Get the 'DateFrom' element value. Description: Date from..Constraints: Required.
     * 
     * @return value
     */
    public Date getDateFrom() {
        return dateFrom;
    }

    /** 
     * Set the 'DateFrom' element value. Description: Date from..Constraints: Required.
     * 
     * @param dateFrom
     */
    public void setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
    }

    /** 
     * Get the 'DateTo' element value. Description: Date to..Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public Date getDateTo() {
        return dateTo;
    }

    /** 
     * Set the 'DateTo' element value. Description: Date to..Constraints: Optional (Not Required).
    						
     * 
     * @param dateTo
     */
    public void setDateTo(Date dateTo) {
        this.dateTo = dateTo;
    }

    /** 
     * Get the 'OutputFields' element value. Description: Output Fields..Constraints: Optional (Not Required).
    						
    							Range: Value must be in the range 0 and 2147483647.
    						
     * 
     * @return value
     */
    public ArrayOfEnumerationsAgencyFields getOutputFields() {
        return outputFields;
    }

    /** 
     * Set the 'OutputFields' element value. Description: Output Fields..Constraints: Optional (Not Required).
    						
    							Range: Value must be in the range 0 and 2147483647.
    						
     * 
     * @param outputFields
     */
    public void setOutputFields(ArrayOfEnumerationsAgencyFields outputFields) {
        this.outputFields = outputFields;
    }
}
