
package org.datacontract.schemas.radixx.connectpoint.travelagents;

import java.util.Date;
import org.datacontract.schemas.radixx.connectpoint.TransactionInfo;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.TravelAgents.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RetrieveTravelAgencyPNRList">
 *   &lt;xs:complexContent mixed="false">
 *     &lt;xs:extension base="ns1:TransactionInfo">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:RetrieveTravelAgencyPNRList.ActionTypes" name="ActionType"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="IATANumber"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="BookingAgent"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="ExternalAppID"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="ConfirmationNumber"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="LastName"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="FirstName"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="FlightNumber"/>
 *         &lt;xs:element type="xs:dateTime" name="FlightDate"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="Origin"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="Destination"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="PaxEmail"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="PaxPhone"/>
 *         &lt;xs:element type="xs:long" name="ProfileID"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="TravelAgencyEmail"/>
 *         &lt;xs:element type="xs:string" nillable="true" name="TravelAgencyPhone"/>
 *         &lt;xs:element type="xs:boolean" name="IncludeActiveBookings"/>
 *         &lt;xs:element type="xs:boolean" name="IncludePastBookings"/>
 *         &lt;xs:element type="xs:boolean" name="IncludeCancelledBookings"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RetrieveTravelAgencyPNRList extends TransactionInfo
{
    private RetrieveTravelAgencyPNRListActionTypes actionType;
    private String IATANumber;
    private String bookingAgent;
    private String externalAppID;
    private String confirmationNumber;
    private String lastName;
    private String firstName;
    private String flightNumber;
    private Date flightDate;
    private String origin;
    private String destination;
    private String paxEmail;
    private String paxPhone;
    private long profileID;
    private String travelAgencyEmail;
    private String travelAgencyPhone;
    private boolean includeActiveBookings;
    private boolean includePastBookings;
    private boolean includeCancelledBookings;

    /** 
     * Get the 'ActionType' element value. 
    							Description: Type indicating whether to search by all travel agency bookings
    							or booking by a single travel agent.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public RetrieveTravelAgencyPNRListActionTypes getActionType() {
        return actionType;
    }

    /** 
     * Set the 'ActionType' element value. 
    							Description: Type indicating whether to search by all travel agency bookings
    							or booking by a single travel agent.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param actionType
     */
    public void setActionType(RetrieveTravelAgencyPNRListActionTypes actionType) {
        this.actionType = actionType;
    }

    /** 
     * Get the 'IATANumber' element value. 
    							Description: CURRENTLY IGNORED - automatically set to IATA number of travel
    							agent currently logged in. The IATA Number for the travel agency
    							that originally created the booking.
    						Constraints: Optional (Not Required).
    						Range: Length must be in the range 1 and 8.
    						Format: AlphaNumericCodeMixedDotDash.
    						
     * 
     * @return value
     */
    public String getIATANumber() {
        return IATANumber;
    }

    /** 
     * Set the 'IATANumber' element value. 
    							Description: CURRENTLY IGNORED - automatically set to IATA number of travel
    							agent currently logged in. The IATA Number for the travel agency
    							that originally created the booking.
    						Constraints: Optional (Not Required).
    						Range: Length must be in the range 1 and 8.
    						Format: AlphaNumericCodeMixedDotDash.
    						
     * 
     * @param IATANumber
     */
    public void setIATANumber(String IATANumber) {
        this.IATANumber = IATANumber;
    }

    /** 
     * Get the 'BookingAgent' element value. 
    							Description: The user ID of the person or the program that initially created
    							the reservation. If the ActionType is set to
    							RetrieveTravelAgentBookings, this will be automatically set to
    							the travel agent currently logged in..
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getBookingAgent() {
        return bookingAgent;
    }

    /** 
     * Set the 'BookingAgent' element value. 
    							Description: The user ID of the person or the program that initially created
    							the reservation. If the ActionType is set to
    							RetrieveTravelAgentBookings, this will be automatically set to
    							the travel agent currently logged in..
    						Constraints: Optional (Not Required).
    						
     * 
     * @param bookingAgent
     */
    public void setBookingAgent(String bookingAgent) {
        this.bookingAgent = bookingAgent;
    }

    /** 
     * Get the 'ExternalAppID' element value. 
    							Description: The External application ID for the travel agency that
    							originally created the booking.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getExternalAppID() {
        return externalAppID;
    }

    /** 
     * Set the 'ExternalAppID' element value. 
    							Description: The External application ID for the travel agency that
    							originally created the booking.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param externalAppID
     */
    public void setExternalAppID(String externalAppID) {
        this.externalAppID = externalAppID;
    }

    /** 
     * Get the 'ConfirmationNumber' element value. 
    							Description: The system-generated confirmation number that is used to
    							uniquely identify a reservation in the Radixx system.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getConfirmationNumber() {
        return confirmationNumber;
    }

    /** 
     * Set the 'ConfirmationNumber' element value. 
    							Description: The system-generated confirmation number that is used to
    							uniquely identify a reservation in the Radixx system.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param confirmationNumber
     */
    public void setConfirmationNumber(String confirmationNumber) {
        this.confirmationNumber = confirmationNumber;
    }

    /** 
     * Get the 'LastName' element value. Description: The person's last name.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getLastName() {
        return lastName;
    }

    /** 
     * Set the 'LastName' element value. Description: The person's last name.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param lastName
     */
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    /** 
     * Get the 'FirstName' element value. Description: The person's first name.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getFirstName() {
        return firstName;
    }

    /** 
     * Set the 'FirstName' element value. Description: The person's first name.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param firstName
     */
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    /** 
     * Get the 'FlightNumber' element value. Description: The flight number.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getFlightNumber() {
        return flightNumber;
    }

    /** 
     * Set the 'FlightNumber' element value. Description: The flight number.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param flightNumber
     */
    public void setFlightNumber(String flightNumber) {
        this.flightNumber = flightNumber;
    }

    /** 
     * Get the 'FlightDate' element value. Description: The departure date of the flight.
    						Constraints: Required.
     * 
     * @return value
     */
    public Date getFlightDate() {
        return flightDate;
    }

    /** 
     * Set the 'FlightDate' element value. Description: The departure date of the flight.
    						Constraints: Required.
     * 
     * @param flightDate
     */
    public void setFlightDate(Date flightDate) {
        this.flightDate = flightDate;
    }

    /** 
     * Get the 'Origin' element value. Description: Origin airport code.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getOrigin() {
        return origin;
    }

    /** 
     * Set the 'Origin' element value. Description: Origin airport code.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param origin
     */
    public void setOrigin(String origin) {
        this.origin = origin;
    }

    /** 
     * Get the 'Destination' element value. Description: Destination airport code.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getDestination() {
        return destination;
    }

    /** 
     * Set the 'Destination' element value. Description: Destination airport code.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param destination
     */
    public void setDestination(String destination) {
        this.destination = destination;
    }

    /** 
     * Get the 'PaxEmail' element value. Description: The passenger's email address.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getPaxEmail() {
        return paxEmail;
    }

    /** 
     * Set the 'PaxEmail' element value. Description: The passenger's email address.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param paxEmail
     */
    public void setPaxEmail(String paxEmail) {
        this.paxEmail = paxEmail;
    }

    /** 
     * Get the 'PaxPhone' element value. Description: The passenger's phone number.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getPaxPhone() {
        return paxPhone;
    }

    /** 
     * Set the 'PaxPhone' element value. Description: The passenger's phone number.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param paxPhone
     */
    public void setPaxPhone(String paxPhone) {
        this.paxPhone = paxPhone;
    }

    /** 
     * Get the 'ProfileID' element value. 
    							Description: The ID of the Radixx profile to which this person is
    							associated. This can be used to determine the number of times a
    							passenger has travelled. (Submit Int64/Long MinValue is string
    							is meant to be empty).
    						Constraints: Required.
     * 
     * @return value
     */
    public long getProfileID() {
        return profileID;
    }

    /** 
     * Set the 'ProfileID' element value. 
    							Description: The ID of the Radixx profile to which this person is
    							associated. This can be used to determine the number of times a
    							passenger has travelled. (Submit Int64/Long MinValue is string
    							is meant to be empty).
    						Constraints: Required.
     * 
     * @param profileID
     */
    public void setProfileID(long profileID) {
        this.profileID = profileID;
    }

    /** 
     * Get the 'TravelAgencyEmail' element value. Description: The travel agency's email address.
    						Constraints: Optional (Not Required).
    						Format: Email.
     * 
     * @return value
     */
    public String getTravelAgencyEmail() {
        return travelAgencyEmail;
    }

    /** 
     * Set the 'TravelAgencyEmail' element value. Description: The travel agency's email address.
    						Constraints: Optional (Not Required).
    						Format: Email.
     * 
     * @param travelAgencyEmail
     */
    public void setTravelAgencyEmail(String travelAgencyEmail) {
        this.travelAgencyEmail = travelAgencyEmail;
    }

    /** 
     * Get the 'TravelAgencyPhone' element value. Description: The travel agency's phone number.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public String getTravelAgencyPhone() {
        return travelAgencyPhone;
    }

    /** 
     * Set the 'TravelAgencyPhone' element value. Description: The travel agency's phone number.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param travelAgencyPhone
     */
    public void setTravelAgencyPhone(String travelAgencyPhone) {
        this.travelAgencyPhone = travelAgencyPhone;
    }

    /** 
     * Get the 'IncludeActiveBookings' element value. 
    							Description: A boolean value indicating whether or not to search active
    							bookings.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public boolean isIncludeActiveBookings() {
        return includeActiveBookings;
    }

    /** 
     * Set the 'IncludeActiveBookings' element value. 
    							Description: A boolean value indicating whether or not to search active
    							bookings.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param includeActiveBookings
     */
    public void setIncludeActiveBookings(boolean includeActiveBookings) {
        this.includeActiveBookings = includeActiveBookings;
    }

    /** 
     * Get the 'IncludePastBookings' element value. 
    							Description: A boolean value indicating whether or not to search past
    							bookings.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public boolean isIncludePastBookings() {
        return includePastBookings;
    }

    /** 
     * Set the 'IncludePastBookings' element value. 
    							Description: A boolean value indicating whether or not to search past
    							bookings.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param includePastBookings
     */
    public void setIncludePastBookings(boolean includePastBookings) {
        this.includePastBookings = includePastBookings;
    }

    /** 
     * Get the 'IncludeCancelledBookings' element value. 
    							Description: A boolean value indicating whether or not to search cancelled
    							bookings.
    						Constraints: Optional (Not Required).
    						
     * 
     * @return value
     */
    public boolean isIncludeCancelledBookings() {
        return includeCancelledBookings;
    }

    /** 
     * Set the 'IncludeCancelledBookings' element value. 
    							Description: A boolean value indicating whether or not to search cancelled
    							bookings.
    						Constraints: Optional (Not Required).
    						
     * 
     * @param includeCancelledBookings
     */
    public void setIncludeCancelledBookings(boolean includeCancelledBookings) {
        this.includeCancelledBookings = includeCancelledBookings;
    }
}
