
package org.datacontract.schemas.radixx.connectpoint.travelagents;

import org.datacontract.schemas.radixx.connectpoint.EnumerationsContactTypes;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.TravelAgents.Request" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Request" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TAContactInfo">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" nillable="true" name="OriginalContactFieldValue" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ContactField"/>
 *     &lt;xs:element type="ns1:Enumerations.ContactTypes" name="ContactType"/>
 *     &lt;xs:element type="xs:boolean" name="PreferredContactMethod"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TAContactInfo
{
    private String originalContactFieldValue;
    private String contactField;
    private EnumerationsContactTypes contactType;
    private boolean preferredContactMethod;

    /** 
     * Get the 'OriginalContactFieldValue' element value. 
    					Description: If modifying the contact then this value represent the value that
    					was set prior to the new change being submitted. However when in
    					create Agency Operation the value is not required as it is not
    					evaluated..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 64.
    				
     * 
     * @return value
     */
    public String getOriginalContactFieldValue() {
        return originalContactFieldValue;
    }

    /** 
     * Set the 'OriginalContactFieldValue' element value. 
    					Description: If modifying the contact then this value represent the value that
    					was set prior to the new change being submitted. However when in
    					create Agency Operation the value is not required as it is not
    					evaluated..
    				Constraints: Optional (Not Required).
    				Range: Length must be in the range 1 and 64.
    				
     * 
     * @param originalContactFieldValue
     */
    public void setOriginalContactFieldValue(String originalContactFieldValue) {
        this.originalContactFieldValue = originalContactFieldValue;
    }

    /** 
     * Get the 'ContactField' element value. Description: The field for the contact..
    				Constraints: Required.
    					Range: Length must be in the range -2147483648 and 2147483647.
    				
     * 
     * @return value
     */
    public String getContactField() {
        return contactField;
    }

    /** 
     * Set the 'ContactField' element value. Description: The field for the contact..
    				Constraints: Required.
    					Range: Length must be in the range -2147483648 and 2147483647.
    				
     * 
     * @param contactField
     */
    public void setContactField(String contactField) {
        this.contactField = contactField;
    }

    /** 
     * Get the 'ContactType' element value. 
    					Description: The code that represents the specified mode for the contact.
    					Use:0 = Home Phone 1 = Work Phone 2 = Mobile Phone 3 = Pager 4 =
    					E-mail 5 = Fax.
    				Constraints: Required.
     * 
     * @return value
     */
    public EnumerationsContactTypes getContactType() {
        return contactType;
    }

    /** 
     * Set the 'ContactType' element value. 
    					Description: The code that represents the specified mode for the contact.
    					Use:0 = Home Phone 1 = Work Phone 2 = Mobile Phone 3 = Pager 4 =
    					E-mail 5 = Fax.
    				Constraints: Required.
     * 
     * @param contactType
     */
    public void setContactType(EnumerationsContactTypes contactType) {
        this.contactType = contactType;
    }

    /** 
     * Get the 'PreferredContactMethod' element value.
     * 
     * @return value
     */
    public boolean isPreferredContactMethod() {
        return preferredContactMethod;
    }

    /** 
     * Set the 'PreferredContactMethod' element value.
     * 
     * @param preferredContactMethod
     */
    public void setPreferredContactMethod(boolean preferredContactMethod) {
        this.preferredContactMethod = preferredContactMethod;
    }
}
