
package org.datacontract.schemas.radixx.connectpoint.travelagents;

import java.math.BigDecimal;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.TravelAgents.Response" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelAgencyCommission">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:decimal" name="Amount"/>
 *     &lt;xs:element type="xs:boolean" name="IsPercentage"/>
 *     &lt;xs:element type="xs:decimal" name="MinAmount"/>
 *     &lt;xs:element type="xs:decimal" name="MaxAmount"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="PaymentMethod"/>
 *     &lt;xs:element type="xs:boolean" name="AssessAsFee"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TravelAgencyCommission
{
    private BigDecimal amount;
    private boolean isPercentage;
    private BigDecimal minAmount;
    private BigDecimal maxAmount;
    private String paymentMethod;
    private boolean assessAsFee;

    /** 
     * Get the 'Amount' element value. Description: Commission Value..
    				Constraints: Required.
     * 
     * @return value
     */
    public BigDecimal getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. Description: Commission Value..
    				Constraints: Required.
     * 
     * @param amount
     */
    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'IsPercentage' element value. 
    					Description: Indicator as to whether the amount is a percentage or a flat
    					amount. If False the the amount returned is a flat amount..
    				Constraints: Required.
     * 
     * @return value
     */
    public boolean isIsPercentage() {
        return isPercentage;
    }

    /** 
     * Set the 'IsPercentage' element value. 
    					Description: Indicator as to whether the amount is a percentage or a flat
    					amount. If False the the amount returned is a flat amount..
    				Constraints: Required.
     * 
     * @param isPercentage
     */
    public void setIsPercentage(boolean isPercentage) {
        this.isPercentage = isPercentage;
    }

    /** 
     * Get the 'MinAmount' element value. 
    					Description: Minimal Allowed amount for the commission.
    				Constraints: Required.
     * 
     * @return value
     */
    public BigDecimal getMinAmount() {
        return minAmount;
    }

    /** 
     * Set the 'MinAmount' element value. 
    					Description: Minimal Allowed amount for the commission.
    				Constraints: Required.
     * 
     * @param minAmount
     */
    public void setMinAmount(BigDecimal minAmount) {
        this.minAmount = minAmount;
    }

    /** 
     * Get the 'MaxAmount' element value. 
    					Description: Maximum Allowed amount for the commission.
    				Constraints: Required.
     * 
     * @return value
     */
    public BigDecimal getMaxAmount() {
        return maxAmount;
    }

    /** 
     * Set the 'MaxAmount' element value. 
    					Description: Maximum Allowed amount for the commission.
    				Constraints: Required.
     * 
     * @param maxAmount
     */
    public void setMaxAmount(BigDecimal maxAmount) {
        this.maxAmount = maxAmount;
    }

    /** 
     * Get the 'PaymentMethod' element value. 
    					Description: The payment method that the commission applies to..
    				Constraints: Required.
     * 
     * @return value
     */
    public String getPaymentMethod() {
        return paymentMethod;
    }

    /** 
     * Set the 'PaymentMethod' element value. 
    					Description: The payment method that the commission applies to..
    				Constraints: Required.
     * 
     * @param paymentMethod
     */
    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    /** 
     * Get the 'AssessAsFee' element value. 
    					Description: If the agency is set to have the percentage of commission offset
    					by a added fee to the consumer than this value will be true so,
    					that amount will be calculated in what is due from the consumer..
    				Constraints: Required.
     * 
     * @return value
     */
    public boolean isAssessAsFee() {
        return assessAsFee;
    }

    /** 
     * Set the 'AssessAsFee' element value. 
    					Description: If the agency is set to have the percentage of commission offset
    					by a added fee to the consumer than this value will be true so,
    					that amount will be calculated in what is due from the consumer..
    				Constraints: Required.
     * 
     * @param assessAsFee
     */
    public void setAssessAsFee(boolean assessAsFee) {
        this.assessAsFee = assessAsFee;
    }
}
