
package org.datacontract.schemas.radixx.connectpoint.travelagents;

import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.TravelAgents.Response" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelAgencyPNR">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" nillable="true" name="SeriesNumber"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ConfirmationNumber"/>
 *     &lt;xs:element type="xs:dateTime" name="BookDate"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="IATANumber"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ReservationCurrency"/>
 *     &lt;xs:element type="xs:long" name="LogicalFlightID"/>
 *     &lt;xs:element type="xs:dateTime" name="DepartureDate"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="FlightNumber"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="FromAirport"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ToAirport"/>
 *     &lt;xs:element type="xs:int" name="Stops"/>
 *     &lt;xs:element type="xs:int" name="ReservationSegmentStatus"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="BookingAgent"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TravelAgencyPNR
{
    private String seriesNumber;
    private String confirmationNumber;
    private Date bookDate;
    private String IATANumber;
    private String reservationCurrency;
    private long logicalFlightID;
    private Date departureDate;
    private String flightNumber;
    private String fromAirport;
    private String toAirport;
    private int stops;
    private int reservationSegmentStatus;
    private String bookingAgent;

    /** 
     * Get the 'SeriesNumber' element value. 
    					Description: The series number for this reservation. For now always '299'.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getSeriesNumber() {
        return seriesNumber;
    }

    /** 
     * Set the 'SeriesNumber' element value. 
    					Description: The series number for this reservation. For now always '299'.
    				Constraints: Required.
     * 
     * @param seriesNumber
     */
    public void setSeriesNumber(String seriesNumber) {
        this.seriesNumber = seriesNumber;
    }

    /** 
     * Get the 'ConfirmationNumber' element value. 
    					Description: The system-generated confirmation number that is used to uniquely
    					identify a reservation in the Radixx system.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getConfirmationNumber() {
        return confirmationNumber;
    }

    /** 
     * Set the 'ConfirmationNumber' element value. 
    					Description: The system-generated confirmation number that is used to uniquely
    					identify a reservation in the Radixx system.
    				Constraints: Required.
     * 
     * @param confirmationNumber
     */
    public void setConfirmationNumber(String confirmationNumber) {
        this.confirmationNumber = confirmationNumber;
    }

    /** 
     * Get the 'BookDate' element value. 
    					Description: The date/time this reservation was created in the system, in GMT.
    				Constraints: Required.
     * 
     * @return value
     */
    public Date getBookDate() {
        return bookDate;
    }

    /** 
     * Set the 'BookDate' element value. 
    					Description: The date/time this reservation was created in the system, in GMT.
    				Constraints: Required.
     * 
     * @param bookDate
     */
    public void setBookDate(Date bookDate) {
        this.bookDate = bookDate;
    }

    /** 
     * Get the 'IATANumber' element value. 
    					Description: The External application ID for the travel agency that originally
    					created the booking.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getIATANumber() {
        return IATANumber;
    }

    /** 
     * Set the 'IATANumber' element value. 
    					Description: The External application ID for the travel agency that originally
    					created the booking.
    				Constraints: Required.
     * 
     * @param IATANumber
     */
    public void setIATANumber(String IATANumber) {
        this.IATANumber = IATANumber;
    }

    /** 
     * Get the 'ReservationCurrency' element value. 
    					Description: The Reservation Currency for this booking. The reservation
    					currency will dictate the currency for all fares on this
    					reservation.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getReservationCurrency() {
        return reservationCurrency;
    }

    /** 
     * Set the 'ReservationCurrency' element value. 
    					Description: The Reservation Currency for this booking. The reservation
    					currency will dictate the currency for all fares on this
    					reservation.
    				Constraints: Required.
     * 
     * @param reservationCurrency
     */
    public void setReservationCurrency(String reservationCurrency) {
        this.reservationCurrency = reservationCurrency;
    }

    /** 
     * Get the 'LogicalFlightID' element value. 
    					Description: The automatically system generated unique identifier for the
    					booked light (known as a logical flight)..
    				Constraints: Required.
     * 
     * @return value
     */
    public long getLogicalFlightID() {
        return logicalFlightID;
    }

    /** 
     * Set the 'LogicalFlightID' element value. 
    					Description: The automatically system generated unique identifier for the
    					booked light (known as a logical flight)..
    				Constraints: Required.
     * 
     * @param logicalFlightID
     */
    public void setLogicalFlightID(long logicalFlightID) {
        this.logicalFlightID = logicalFlightID;
    }

    /** 
     * Get the 'DepartureDate' element value. 
    					Description: The day the flight takes leave. Use 01/01/0001 12:00:00 AM to
    					retrieve all dates..
    				Constraints: Required.
     * 
     * @return value
     */
    public Date getDepartureDate() {
        return departureDate;
    }

    /** 
     * Set the 'DepartureDate' element value. 
    					Description: The day the flight takes leave. Use 01/01/0001 12:00:00 AM to
    					retrieve all dates..
    				Constraints: Required.
     * 
     * @param departureDate
     */
    public void setDepartureDate(Date departureDate) {
        this.departureDate = departureDate;
    }

    /** 
     * Get the 'FlightNumber' element value. Description: The number for this flight.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getFlightNumber() {
        return flightNumber;
    }

    /** 
     * Set the 'FlightNumber' element value. Description: The number for this flight.
    				Constraints: Required.
     * 
     * @param flightNumber
     */
    public void setFlightNumber(String flightNumber) {
        this.flightNumber = flightNumber;
    }

    /** 
     * Get the 'FromAirport' element value. Description: The Airport the flight takes leave..
    				Constraints: Required.
     * 
     * @return value
     */
    public String getFromAirport() {
        return fromAirport;
    }

    /** 
     * Set the 'FromAirport' element value. Description: The Airport the flight takes leave..
    				Constraints: Required.
     * 
     * @param fromAirport
     */
    public void setFromAirport(String fromAirport) {
        this.fromAirport = fromAirport;
    }

    /** 
     * Get the 'ToAirport' element value. Description: The Airport the flight arrives..
    				Constraints: Required.
     * 
     * @return value
     */
    public String getToAirport() {
        return toAirport;
    }

    /** 
     * Set the 'ToAirport' element value. Description: The Airport the flight arrives..
    				Constraints: Required.
     * 
     * @param toAirport
     */
    public void setToAirport(String toAirport) {
        this.toAirport = toAirport;
    }

    /** 
     * Get the 'Stops' element value. Description: The number of stops for this flight.
    				Constraints: Required.
     * 
     * @return value
     */
    public int getStops() {
        return stops;
    }

    /** 
     * Set the 'Stops' element value. Description: The number of stops for this flight.
    				Constraints: Required.
     * 
     * @param stops
     */
    public void setStops(int stops) {
        this.stops = stops;
    }

    /** 
     * Get the 'ReservationSegmentStatus' element value. Description: The status of the flight segment.
    				Constraints: Required.
     * 
     * @return value
     */
    public int getReservationSegmentStatus() {
        return reservationSegmentStatus;
    }

    /** 
     * Set the 'ReservationSegmentStatus' element value. Description: The status of the flight segment.
    				Constraints: Required.
     * 
     * @param reservationSegmentStatus
     */
    public void setReservationSegmentStatus(int reservationSegmentStatus) {
        this.reservationSegmentStatus = reservationSegmentStatus;
    }

    /** 
     * Get the 'BookingAgent' element value. Description: The booking agent for this flight.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getBookingAgent() {
        return bookingAgent;
    }

    /** 
     * Set the 'BookingAgent' element value. Description: The booking agent for this flight.
    				Constraints: Required.
     * 
     * @param bookingAgent
     */
    public void setBookingAgent(String bookingAgent) {
        this.bookingAgent = bookingAgent;
    }
}
