
package org.datacontract.schemas.radixx.connectpoint.travelagents;

import java.math.BigDecimal;
import org.datacontract.schemas.radixx.connectpoint.ExceptionInformationExceptions;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Exceptions" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.TravelAgents.Response" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ViewAgencyListItem">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" nillable="true" name="IataCode"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="AgencyName"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="CurrencyCode"/>
 *     &lt;xs:element type="xs:decimal" name="AvailableBalance"/>
 *     &lt;xs:element type="xs:int" name="NumberOfBookings"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="TravelAgentStatus"/>
 *     &lt;xs:element type="ns:ExceptionInformation.Exceptions" nillable="true" name="Exceptions"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ViewAgencyListItem
{
    private String iataCode;
    private String agencyName;
    private String currencyCode;
    private BigDecimal availableBalance;
    private int numberOfBookings;
    private String travelAgentStatus;
    private ExceptionInformationExceptions exceptions;

    /** 
     * Get the 'IataCode' element value. 
    					Description: The IATA number for this Travel Agency.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getIataCode() {
        return iataCode;
    }

    /** 
     * Set the 'IataCode' element value. 
    					Description: The IATA number for this Travel Agency.
    				Constraints: Required.
     * 
     * @param iataCode
     */
    public void setIataCode(String iataCode) {
        this.iataCode = iataCode;
    }

    /** 
     * Get the 'AgencyName' element value. 
    					Description: The Agency Name associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getAgencyName() {
        return agencyName;
    }

    /** 
     * Set the 'AgencyName' element value. 
    					Description: The Agency Name associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @param agencyName
     */
    public void setAgencyName(String agencyName) {
        this.agencyName = agencyName;
    }

    /** 
     * Get the 'CurrencyCode' element value. 
    					Description: The Currency Code associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'CurrencyCode' element value. 
    					Description: The Currency Code associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /** 
     * Get the 'AvailableBalance' element value. 
    					Description: The Credit Limit associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @return value
     */
    public BigDecimal getAvailableBalance() {
        return availableBalance;
    }

    /** 
     * Set the 'AvailableBalance' element value. 
    					Description: The Credit Limit associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @param availableBalance
     */
    public void setAvailableBalance(BigDecimal availableBalance) {
        this.availableBalance = availableBalance;
    }

    /** 
     * Get the 'NumberOfBookings' element value. 
    					Description: No. Of bookings associated with this Travel Agency (all active
    					bookings with at least one segment active or flown For last 30
    					days. not cancelled /fully flown/no show booking).
    				Constraints: Required.
     * 
     * @return value
     */
    public int getNumberOfBookings() {
        return numberOfBookings;
    }

    /** 
     * Set the 'NumberOfBookings' element value. 
    					Description: No. Of bookings associated with this Travel Agency (all active
    					bookings with at least one segment active or flown For last 30
    					days. not cancelled /fully flown/no show booking).
    				Constraints: Required.
     * 
     * @param numberOfBookings
     */
    public void setNumberOfBookings(int numberOfBookings) {
        this.numberOfBookings = numberOfBookings;
    }

    /** 
     * Get the 'TravelAgentStatus' element value. 
    					Description: The Travel Agent Status associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getTravelAgentStatus() {
        return travelAgentStatus;
    }

    /** 
     * Set the 'TravelAgentStatus' element value. 
    					Description: The Travel Agent Status associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @param travelAgentStatus
     */
    public void setTravelAgentStatus(String travelAgentStatus) {
        this.travelAgentStatus = travelAgentStatus;
    }

    /** 
     * Get the 'Exceptions' element value. 
    					Description: The collection of returned exceptions or results.
    				Constraints: Required.
     * 
     * @return value
     */
    public ExceptionInformationExceptions getExceptions() {
        return exceptions;
    }

    /** 
     * Set the 'Exceptions' element value. 
    					Description: The collection of returned exceptions or results.
    				Constraints: Required.
     * 
     * @param exceptions
     */
    public void setExceptions(ExceptionInformationExceptions exceptions) {
        this.exceptions = exceptions;
    }
}
