
package org.datacontract.schemas.radixx.connectpoint.travelagents;

import java.math.BigDecimal;
import org.datacontract.schemas.radixx.connectpoint.ExceptionInformationExceptions;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.Exceptions" xmlns:ns1="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.TravelAgents.Response" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ViewAgencywithCCInfo">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" nillable="true" name="IataCode"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="PersonOrgId"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ContactName"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="CurrencyCode"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ParentIataCode"/>
 *     &lt;xs:element type="xs:decimal" name="Commission"/>
 *     &lt;xs:element type="xs:decimal" name="CreditLimit"/>
 *     &lt;xs:element type="xs:boolean" name="FetExempt"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="BankNumber"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="TravelAgentStatus"/>
 *     &lt;xs:element type="xs:int" name="ConsortTravalAgentId"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="FareBasisCode"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="AccountId"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="FederalId"/>
 *     &lt;xs:element type="xs:boolean" name="EmailReceipt"/>
 *     &lt;xs:element type="xs:boolean" name="FaxReceipt"/>
 *     &lt;xs:element type="xs:boolean" name="MailReceipt"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Comments"/>
 *     &lt;xs:element type="xs:boolean" name="Prepaid"/>
 *     &lt;xs:element type="xs:int" name="TravelAgentTypeId"/>
 *     &lt;xs:element type="xs:boolean" name="CanViewAllPnrs"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Address1"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Address2"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="CompanyName"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="City"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="State"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ZipCode"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Country"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Phone"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Email"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Fax"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="TravelAgentUserName"/>
 *     &lt;xs:element type="ns1:ArrayOfAgencyCreditCardInfo" nillable="true" name="CreditCardAccounts"/>
 *     &lt;xs:element type="ns:ExceptionInformation.Exceptions" nillable="true" name="Exceptions"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ViewAgencywithCCInfo
{
    private String iataCode;
    private String personOrgId;
    private String contactName;
    private String currencyCode;
    private String parentIataCode;
    private BigDecimal commission;
    private BigDecimal creditLimit;
    private boolean fetExempt;
    private String bankNumber;
    private String travelAgentStatus;
    private int consortTravalAgentId;
    private String fareBasisCode;
    private String accountId;
    private String federalId;
    private boolean emailReceipt;
    private boolean faxReceipt;
    private boolean mailReceipt;
    private String comments;
    private boolean prepaid;
    private int travelAgentTypeId;
    private boolean canViewAllPnrs;
    private String address1;
    private String address2;
    private String companyName;
    private String city;
    private String state;
    private String zipCode;
    private String country;
    private String phone;
    private String email;
    private String fax;
    private String travelAgentUserName;
    private ArrayOfAgencyCreditCardInfo creditCardAccounts;
    private ExceptionInformationExceptions exceptions;

    /** 
     * Get the 'IataCode' element value. 
    					Description: The IATA number for this Travel Agency.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getIataCode() {
        return iataCode;
    }

    /** 
     * Set the 'IataCode' element value. 
    					Description: The IATA number for this Travel Agency.
    				Constraints: Required.
     * 
     * @param iataCode
     */
    public void setIataCode(String iataCode) {
        this.iataCode = iataCode;
    }

    /** 
     * Get the 'PersonOrgId' element value. 
    					Description: The Person Org. Id associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getPersonOrgId() {
        return personOrgId;
    }

    /** 
     * Set the 'PersonOrgId' element value. 
    					Description: The Person Org. Id associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @param personOrgId
     */
    public void setPersonOrgId(String personOrgId) {
        this.personOrgId = personOrgId;
    }

    /** 
     * Get the 'ContactName' element value. 
    					Description: The Contact Name associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getContactName() {
        return contactName;
    }

    /** 
     * Set the 'ContactName' element value. 
    					Description: The Contact Name associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @param contactName
     */
    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    /** 
     * Get the 'CurrencyCode' element value. 
    					Description: The Currency Code associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'CurrencyCode' element value. 
    					Description: The Currency Code associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /** 
     * Get the 'ParentIataCode' element value. 
    					Description: The Parent IAIA Number associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getParentIataCode() {
        return parentIataCode;
    }

    /** 
     * Set the 'ParentIataCode' element value. 
    					Description: The Parent IAIA Number associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @param parentIataCode
     */
    public void setParentIataCode(String parentIataCode) {
        this.parentIataCode = parentIataCode;
    }

    /** 
     * Get the 'Commission' element value. 
    					Description: The Commission associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @return value
     */
    public BigDecimal getCommission() {
        return commission;
    }

    /** 
     * Set the 'Commission' element value. 
    					Description: The Commission associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @param commission
     */
    public void setCommission(BigDecimal commission) {
        this.commission = commission;
    }

    /** 
     * Get the 'CreditLimit' element value. 
    					Description: The Credit Limit associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @return value
     */
    public BigDecimal getCreditLimit() {
        return creditLimit;
    }

    /** 
     * Set the 'CreditLimit' element value. 
    					Description: The Credit Limit associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @param creditLimit
     */
    public void setCreditLimit(BigDecimal creditLimit) {
        this.creditLimit = creditLimit;
    }

    /** 
     * Get the 'FetExempt' element value. 
    					Description: The Fet Exempt field associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @return value
     */
    public boolean isFetExempt() {
        return fetExempt;
    }

    /** 
     * Set the 'FetExempt' element value. 
    					Description: The Fet Exempt field associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @param fetExempt
     */
    public void setFetExempt(boolean fetExempt) {
        this.fetExempt = fetExempt;
    }

    /** 
     * Get the 'BankNumber' element value. 
    					Description: The Bank Number associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getBankNumber() {
        return bankNumber;
    }

    /** 
     * Set the 'BankNumber' element value. 
    					Description: The Bank Number associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @param bankNumber
     */
    public void setBankNumber(String bankNumber) {
        this.bankNumber = bankNumber;
    }

    /** 
     * Get the 'TravelAgentStatus' element value. 
    					Description: The Travel Agent Status associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getTravelAgentStatus() {
        return travelAgentStatus;
    }

    /** 
     * Set the 'TravelAgentStatus' element value. 
    					Description: The Travel Agent Status associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @param travelAgentStatus
     */
    public void setTravelAgentStatus(String travelAgentStatus) {
        this.travelAgentStatus = travelAgentStatus;
    }

    /** 
     * Get the 'ConsortTravalAgentId' element value. 
    					Description: The Consort Travel Agent Id associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @return value
     */
    public int getConsortTravalAgentId() {
        return consortTravalAgentId;
    }

    /** 
     * Set the 'ConsortTravalAgentId' element value. 
    					Description: The Consort Travel Agent Id associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @param consortTravalAgentId
     */
    public void setConsortTravalAgentId(int consortTravalAgentId) {
        this.consortTravalAgentId = consortTravalAgentId;
    }

    /** 
     * Get the 'FareBasisCode' element value. 
    					Description: The Fare Basis Code associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getFareBasisCode() {
        return fareBasisCode;
    }

    /** 
     * Set the 'FareBasisCode' element value. 
    					Description: The Fare Basis Code associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @param fareBasisCode
     */
    public void setFareBasisCode(String fareBasisCode) {
        this.fareBasisCode = fareBasisCode;
    }

    /** 
     * Get the 'AccountId' element value. 
    					Description: The Account ID associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getAccountId() {
        return accountId;
    }

    /** 
     * Set the 'AccountId' element value. 
    					Description: The Account ID associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @param accountId
     */
    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    /** 
     * Get the 'FederalId' element value. 
    					Description: The Federal ID associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getFederalId() {
        return federalId;
    }

    /** 
     * Set the 'FederalId' element value. 
    					Description: The Federal ID associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @param federalId
     */
    public void setFederalId(String federalId) {
        this.federalId = federalId;
    }

    /** 
     * Get the 'EmailReceipt' element value. Description: Indicator of Email Receipt.
    				Constraints: Required.
     * 
     * @return value
     */
    public boolean isEmailReceipt() {
        return emailReceipt;
    }

    /** 
     * Set the 'EmailReceipt' element value. Description: Indicator of Email Receipt.
    				Constraints: Required.
     * 
     * @param emailReceipt
     */
    public void setEmailReceipt(boolean emailReceipt) {
        this.emailReceipt = emailReceipt;
    }

    /** 
     * Get the 'FaxReceipt' element value. Description: Indicator of Fax Receipt.
    				Constraints: Required.
     * 
     * @return value
     */
    public boolean isFaxReceipt() {
        return faxReceipt;
    }

    /** 
     * Set the 'FaxReceipt' element value. Description: Indicator of Fax Receipt.
    				Constraints: Required.
     * 
     * @param faxReceipt
     */
    public void setFaxReceipt(boolean faxReceipt) {
        this.faxReceipt = faxReceipt;
    }

    /** 
     * Get the 'MailReceipt' element value. Description: Indicator of Mail Receipt.
    				Constraints: Required.
     * 
     * @return value
     */
    public boolean isMailReceipt() {
        return mailReceipt;
    }

    /** 
     * Set the 'MailReceipt' element value. Description: Indicator of Mail Receipt.
    				Constraints: Required.
     * 
     * @param mailReceipt
     */
    public void setMailReceipt(boolean mailReceipt) {
        this.mailReceipt = mailReceipt;
    }

    /** 
     * Get the 'Comments' element value. 
    					Description: Comments associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getComments() {
        return comments;
    }

    /** 
     * Set the 'Comments' element value. 
    					Description: Comments associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @param comments
     */
    public void setComments(String comments) {
        this.comments = comments;
    }

    /** 
     * Get the 'Prepaid' element value. 
    					Description: Prepaid indicator associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @return value
     */
    public boolean isPrepaid() {
        return prepaid;
    }

    /** 
     * Set the 'Prepaid' element value. 
    					Description: Prepaid indicator associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @param prepaid
     */
    public void setPrepaid(boolean prepaid) {
        this.prepaid = prepaid;
    }

    /** 
     * Get the 'TravelAgentTypeId' element value. 
    					Description: Travel Agent Type ID associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @return value
     */
    public int getTravelAgentTypeId() {
        return travelAgentTypeId;
    }

    /** 
     * Set the 'TravelAgentTypeId' element value. 
    					Description: Travel Agent Type ID associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @param travelAgentTypeId
     */
    public void setTravelAgentTypeId(int travelAgentTypeId) {
        this.travelAgentTypeId = travelAgentTypeId;
    }

    /** 
     * Get the 'CanViewAllPnrs' element value. Description: Can View all PNRs option.
    				Constraints: Required.
     * 
     * @return value
     */
    public boolean isCanViewAllPnrs() {
        return canViewAllPnrs;
    }

    /** 
     * Set the 'CanViewAllPnrs' element value. Description: Can View all PNRs option.
    				Constraints: Required.
     * 
     * @param canViewAllPnrs
     */
    public void setCanViewAllPnrs(boolean canViewAllPnrs) {
        this.canViewAllPnrs = canViewAllPnrs;
    }

    /** 
     * Get the 'Address1' element value. Description: Address1.Constraints: Required.
     * 
     * @return value
     */
    public String getAddress1() {
        return address1;
    }

    /** 
     * Set the 'Address1' element value. Description: Address1.Constraints: Required.
     * 
     * @param address1
     */
    public void setAddress1(String address1) {
        this.address1 = address1;
    }

    /** 
     * Get the 'Address2' element value. Description: Address2.Constraints: Required.
     * 
     * @return value
     */
    public String getAddress2() {
        return address2;
    }

    /** 
     * Set the 'Address2' element value. Description: Address2.Constraints: Required.
     * 
     * @param address2
     */
    public void setAddress2(String address2) {
        this.address2 = address2;
    }

    /** 
     * Get the 'CompanyName' element value. 
    					Description: Name of Company associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getCompanyName() {
        return companyName;
    }

    /** 
     * Set the 'CompanyName' element value. 
    					Description: Name of Company associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @param companyName
     */
    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    /** 
     * Get the 'City' element value. 
    					Description: Name of City associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getCity() {
        return city;
    }

    /** 
     * Set the 'City' element value. 
    					Description: Name of City associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @param city
     */
    public void setCity(String city) {
        this.city = city;
    }

    /** 
     * Get the 'State' element value. 
    					Description: State associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getState() {
        return state;
    }

    /** 
     * Set the 'State' element value. 
    					Description: State associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @param state
     */
    public void setState(String state) {
        this.state = state;
    }

    /** 
     * Get the 'ZipCode' element value. 
    					Description: ZipCode associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getZipCode() {
        return zipCode;
    }

    /** 
     * Set the 'ZipCode' element value. 
    					Description: ZipCode associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @param zipCode
     */
    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    /** 
     * Get the 'Country' element value. 
    					Description: Name of Country associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getCountry() {
        return country;
    }

    /** 
     * Set the 'Country' element value. 
    					Description: Name of Country associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @param country
     */
    public void setCountry(String country) {
        this.country = country;
    }

    /** 
     * Get the 'Phone' element value. 
    					Description: Phone Number associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getPhone() {
        return phone;
    }

    /** 
     * Set the 'Phone' element value. 
    					Description: Phone Number associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @param phone
     */
    public void setPhone(String phone) {
        this.phone = phone;
    }

    /** 
     * Get the 'Email' element value. 
    					Description: Email Address associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getEmail() {
        return email;
    }

    /** 
     * Set the 'Email' element value. 
    					Description: Email Address associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @param email
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /** 
     * Get the 'Fax' element value. 
    					Description: Fax Number associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getFax() {
        return fax;
    }

    /** 
     * Set the 'Fax' element value. 
    					Description: Fax Number associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @param fax
     */
    public void setFax(String fax) {
        this.fax = fax;
    }

    /** 
     * Get the 'TravelAgentUserName' element value. 
    					Description: Travel Agent User Name associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getTravelAgentUserName() {
        return travelAgentUserName;
    }

    /** 
     * Set the 'TravelAgentUserName' element value. 
    					Description: Travel Agent User Name associated with this Travel Agency.
    				Constraints: Required.
     * 
     * @param travelAgentUserName
     */
    public void setTravelAgentUserName(String travelAgentUserName) {
        this.travelAgentUserName = travelAgentUserName;
    }

    /** 
     * Get the 'CreditCardAccounts' element value. 
    					Description: The collection of returned credit card accounts.
    				Constraints: Required.
     * 
     * @return value
     */
    public ArrayOfAgencyCreditCardInfo getCreditCardAccounts() {
        return creditCardAccounts;
    }

    /** 
     * Set the 'CreditCardAccounts' element value. 
    					Description: The collection of returned credit card accounts.
    				Constraints: Required.
     * 
     * @param creditCardAccounts
     */
    public void setCreditCardAccounts(
            ArrayOfAgencyCreditCardInfo creditCardAccounts) {
        this.creditCardAccounts = creditCardAccounts;
    }

    /** 
     * Get the 'Exceptions' element value. 
    					Description: The collection of returned exceptions or results.
    				Constraints: Required.
     * 
     * @return value
     */
    public ExceptionInformationExceptions getExceptions() {
        return exceptions;
    }

    /** 
     * Set the 'Exceptions' element value. 
    					Description: The collection of returned exceptions or results.
    				Constraints: Required.
     * 
     * @param exceptions
     */
    public void setExceptions(ExceptionInformationExceptions exceptions) {
        this.exceptions = exceptions;
    }
}
