
package org.datacontract.schemas.radixx.connectpoint.travelagents;

import java.math.BigDecimal;
import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.datacontract.org/2004/07/Radixx.ConnectPoint.TravelAgents.Response" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ViewBookingsWithPaymentsPending">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" nillable="true" name="SeriesNumber"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="ConfirmationNumber"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="LastName"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="FirstName"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Title"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="CountryCode"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="PhoneNumber"/>
 *     &lt;xs:element type="xs:decimal" name="Amount"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="Currency"/>
 *     &lt;xs:element type="xs:dateTime" name="PaymentDue"/>
 *     &lt;xs:element type="xs:string" nillable="true" name="DepartureAirport"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ViewBookingsWithPaymentsPending
{
    private String seriesNumber;
    private String confirmationNumber;
    private String lastName;
    private String firstName;
    private String title;
    private String countryCode;
    private String phoneNumber;
    private BigDecimal amount;
    private String currency;
    private Date paymentDue;
    private String departureAirport;

    /** 
     * Get the 'SeriesNumber' element value. 
    					Description: The series number for this reservation. For now always '299'.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getSeriesNumber() {
        return seriesNumber;
    }

    /** 
     * Set the 'SeriesNumber' element value. 
    					Description: The series number for this reservation. For now always '299'.
    				Constraints: Required.
     * 
     * @param seriesNumber
     */
    public void setSeriesNumber(String seriesNumber) {
        this.seriesNumber = seriesNumber;
    }

    /** 
     * Get the 'ConfirmationNumber' element value. 
    					Description: The system-generated confirmation number that is used to uniquely
    					identify a reservation in the Radixx system.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getConfirmationNumber() {
        return confirmationNumber;
    }

    /** 
     * Set the 'ConfirmationNumber' element value. 
    					Description: The system-generated confirmation number that is used to uniquely
    					identify a reservation in the Radixx system.
    				Constraints: Required.
     * 
     * @param confirmationNumber
     */
    public void setConfirmationNumber(String confirmationNumber) {
        this.confirmationNumber = confirmationNumber;
    }

    /** 
     * Get the 'LastName' element value. 
    					Description: The lastname of the primary passenger.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getLastName() {
        return lastName;
    }

    /** 
     * Set the 'LastName' element value. 
    					Description: The lastname of the primary passenger.
    				Constraints: Required.
     * 
     * @param lastName
     */
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    /** 
     * Get the 'FirstName' element value. 
    					Description: The firstname of the primary passenger.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getFirstName() {
        return firstName;
    }

    /** 
     * Set the 'FirstName' element value. 
    					Description: The firstname of the primary passenger.
    				Constraints: Required.
     * 
     * @param firstName
     */
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    /** 
     * Get the 'Title' element value. Description: The title of the primary passenger.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getTitle() {
        return title;
    }

    /** 
     * Set the 'Title' element value. Description: The title of the primary passenger.
    				Constraints: Required.
     * 
     * @param title
     */
    public void setTitle(String title) {
        this.title = title;
    }

    /** 
     * Get the 'CountryCode' element value. Description: Contact Number Country Code.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getCountryCode() {
        return countryCode;
    }

    /** 
     * Set the 'CountryCode' element value. Description: Contact Number Country Code.
    				Constraints: Required.
     * 
     * @param countryCode
     */
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    /** 
     * Get the 'PhoneNumber' element value. Description: Contact Number Phone Number.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getPhoneNumber() {
        return phoneNumber;
    }

    /** 
     * Set the 'PhoneNumber' element value. Description: Contact Number Phone Number.
    				Constraints: Required.
     * 
     * @param phoneNumber
     */
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    /** 
     * Get the 'Amount' element value. Description: Amount.Constraints: Required.
     * 
     * @return value
     */
    public BigDecimal getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. Description: Amount.Constraints: Required.
     * 
     * @param amount
     */
    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'Currency' element value. Description: Currency..Constraints: Required.
     * 
     * @return value
     */
    public String getCurrency() {
        return currency;
    }

    /** 
     * Set the 'Currency' element value. Description: Currency..Constraints: Required.
     * 
     * @param currency
     */
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    /** 
     * Get the 'PaymentDue' element value. 
    					Description: Time Duration for TLT Expiry  It is the remaining time for TLT
    					to expire, in hours and minutes.
    				Constraints: Required.
     * 
     * @return value
     */
    public Date getPaymentDue() {
        return paymentDue;
    }

    /** 
     * Set the 'PaymentDue' element value. 
    					Description: Time Duration for TLT Expiry  It is the remaining time for TLT
    					to expire, in hours and minutes.
    				Constraints: Required.
     * 
     * @param paymentDue
     */
    public void setPaymentDue(Date paymentDue) {
        this.paymentDue = paymentDue;
    }

    /** 
     * Get the 'DepartureAirport' element value. Description: Departure Airport.
    				Constraints: Required.
     * 
     * @return value
     */
    public String getDepartureAirport() {
        return departureAirport;
    }

    /** 
     * Set the 'DepartureAirport' element value. Description: Departure Airport.
    				Constraints: Required.
     * 
     * @param departureAirport
     */
    public void setDepartureAirport(String departureAirport) {
        this.departureAirport = departureAirport;
    }
}
