
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * An entity who distributes a Sellerâ€™s shopping request to multiple Airlines and aggregates subsequent responses.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderListRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AggregatorType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="AggregatorID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ContactInfoType" name="ContactInfo" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="Name" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AggregatorType implements Serializable
{
    private String aggregatorID;
    private List<ContactInfoType> contactInfoList = new ArrayList<ContactInfoType>();
    private String name;

    /** 
     * Get the 'AggregatorID' element value. Identifier of the aggregator organization.
     * 
     * @return value
     */
    public String getAggregatorID() {
        return aggregatorID;
    }

    /** 
     * Set the 'AggregatorID' element value. Identifier of the aggregator organization.
     * 
     * @param aggregatorID
     */
    public void setAggregatorID(String aggregatorID) {
        this.aggregatorID = aggregatorID;
    }

    /** 
     * Get the list of 'ContactInfo' element items. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
     * 
     * @return list
     */
    public List<ContactInfoType> getContactInfoList() {
        return contactInfoList;
    }

    /** 
     * Set the list of 'ContactInfo' element items. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
     * 
     * @param list
     */
    public void setContactInfoList(List<ContactInfoType> list) {
        contactInfoList = list;
    }

    /** 
     * Get the 'Name' element value. Aggregator Name.  Example: Farelogix.
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Aggregator Name.  Example: Farelogix.
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }
}
