
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rq;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * Bank Account payment method definition.  Customer bank accounts for payments, either for paper checks or electronic funds transfer.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderListRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BankAccountType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="AccountID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="AccountTypeText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="BankID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:decimal" name="CheckNumber" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OwnerName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="SubCode" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BankAccountType implements Serializable
{
    private String accountID;
    private String accountTypeText;
    private String bankID;
    private BigDecimal checkNumber;
    private String ownerName;
    private String subCode;

    /** 
     * Get the 'AccountID' element value. The bank account number or identifier.
     * 
     * @return value
     */
    public String getAccountID() {
        return accountID;
    }

    /** 
     * Set the 'AccountID' element value. The bank account number or identifier.
     * 
     * @param accountID
     */
    public void setAccountID(String accountID) {
        this.accountID = accountID;
    }

    /** 
     * Get the 'AccountTypeText' element value. Account Type. Examples: Checking, Savings, Investment
     * 
     * @return value
     */
    public String getAccountTypeText() {
        return accountTypeText;
    }

    /** 
     * Set the 'AccountTypeText' element value. Account Type. Examples: Checking, Savings, Investment
     * 
     * @param accountTypeText
     */
    public void setAccountTypeText(String accountTypeText) {
        this.accountTypeText = accountTypeText;
    }

    /** 
     * Get the 'BankID' element value. Routing Number. Example: 0260-0959-3 Note: This is the code assigned by authorities to financial institutions; sometimes called bank routing number.
     * 
     * @return value
     */
    public String getBankID() {
        return bankID;
    }

    /** 
     * Set the 'BankID' element value. Routing Number. Example: 0260-0959-3 Note: This is the code assigned by authorities to financial institutions; sometimes called bank routing number.
     * 
     * @param bankID
     */
    public void setBankID(String bankID) {
        this.bankID = bankID;
    }

    /** 
     * Get the 'CheckNumber' element value. Check or draft number. Example: 1234
     * 
     * @return value
     */
    public BigDecimal getCheckNumber() {
        return checkNumber;
    }

    /** 
     * Set the 'CheckNumber' element value. Check or draft number. Example: 1234
     * 
     * @param checkNumber
     */
    public void setCheckNumber(BigDecimal checkNumber) {
        this.checkNumber = checkNumber;
    }

    /** 
     * Get the 'OwnerName' element value. This is the name the bank account is held under. Example: JOHN SMITH
     * 
     * @return value
     */
    public String getOwnerName() {
        return ownerName;
    }

    /** 
     * Set the 'OwnerName' element value. This is the name the bank account is held under. Example: JOHN SMITH
     * 
     * @param ownerName
     */
    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    /** 
     * Get the 'SubCode' element value. Defines what type of Bank Transfer is currently used for payment to provide a more detailed definition of what the payment actually is.
     * 
     * @return value
     */
    public String getSubCode() {
        return subCode;
    }

    /** 
     * Set the 'SubCode' element value. Defines what type of Bank Transfer is currently used for payment to provide a more detailed definition of what the payment actually is.
     * 
     * @param subCode
     */
    public void setSubCode(String subCode) {
        this.subCode = subCode;
    }
}
