
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rq;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * A company or group of people authorized to act as a single entity (legally a person) and recognized as such in law.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderListRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CorporationType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CorporateCodeText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CorporateID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:decimal" name="IATA_Number" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="Name" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CorporationType implements Serializable
{
    private String corporateCodeText;
    private String corporateID;
    private BigDecimal IATANumber;
    private String name;

    /** 
     * Get the 'CorporateCodeText' element value. Corporate code assigned to a corporate buyer used for accessing special fares.
     * 
     * @return value
     */
    public String getCorporateCodeText() {
        return corporateCodeText;
    }

    /** 
     * Set the 'CorporateCodeText' element value. Corporate code assigned to a corporate buyer used for accessing special fares.
     * 
     * @param corporateCodeText
     */
    public void setCorporateCodeText(String corporateCodeText) {
        this.corporateCodeText = corporateCodeText;
    }

    /** 
     * Get the 'CorporateID' element value. Unique identifier of this corporation.
     * 
     * @return value
     */
    public String getCorporateID() {
        return corporateID;
    }

    /** 
     * Set the 'CorporateID' element value. Unique identifier of this corporation.
     * 
     * @param corporateID
     */
    public void setCorporateID(String corporateID) {
        this.corporateID = corporateID;
    }

    /** 
     * Get the 'IATA_Number' element value. IATA issued identification number.
     * 
     * @return value
     */
    public BigDecimal getIATANumber() {
        return IATANumber;
    }

    /** 
     * Set the 'IATA_Number' element value. IATA issued identification number.
     * 
     * @param IATANumber
     */
    public void setIATANumber(BigDecimal IATANumber) {
        this.IATANumber = IATANumber;
    }

    /** 
     * Get the 'Name' element value. Corporation name
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Corporation name
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }
}
