
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rq;

import java.io.Serializable;

/** 
 * An account set up for a customer within a rewards program which holds funds on behalf of that customer.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderListRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LoyaltyProgramAccountType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="AccountNumber" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CarrierType" name="Carrier" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ProgramCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ProgramName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="SignInID" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class LoyaltyProgramAccountType implements Serializable
{
    private String accountNumber;
    private CarrierType carrier;
    private String programCode;
    private String programName;
    private String signInID;

    /** 
     * Get the 'AccountNumber' element value. Loyalty Program account number. Example: ABC123456
     * 
     * @return value
     */
    public String getAccountNumber() {
        return accountNumber;
    }

    /** 
     * Set the 'AccountNumber' element value. Loyalty Program account number. Example: ABC123456
     * 
     * @param accountNumber
     */
    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    /** 
     * Get the 'Carrier' element value. Includes the carrier issuing the ticket and all carriers that carry or undertake to carry the passenger and/or his baggage or to perform any other services related to such carriage.
     * 
     * @return value
     */
    public CarrierType getCarrier() {
        return carrier;
    }

    /** 
     * Set the 'Carrier' element value. Includes the carrier issuing the ticket and all carriers that carry or undertake to carry the passenger and/or his baggage or to perform any other services related to such carriage.
     * 
     * @param carrier
     */
    public void setCarrier(CarrierType carrier) {
        this.carrier = carrier;
    }

    /** 
     * Get the 'ProgramCode' element value. Loyalty Program ID: Example: MAM
     * 
     * @return value
     */
    public String getProgramCode() {
        return programCode;
    }

    /** 
     * Set the 'ProgramCode' element value. Loyalty Program ID: Example: MAM
     * 
     * @param programCode
     */
    public void setProgramCode(String programCode) {
        this.programCode = programCode;
    }

    /** 
     * Get the 'ProgramName' element value. Loyalty Program Name. Example: Miles and More
     * 
     * @return value
     */
    public String getProgramName() {
        return programName;
    }

    /** 
     * Set the 'ProgramName' element value. Loyalty Program Name. Example: Miles and More
     * 
     * @param programName
     */
    public void setProgramName(String programName) {
        this.programName = programName;
    }

    /** 
     * Get the 'SignInID' element value. Loyalty Program sign-in ID (or username).
     * 
     * @return value
     */
    public String getSignInID() {
        return signInID;
    }

    /** 
     * Set the 'SignInID' element value. Loyalty Program sign-in ID (or username).
     * 
     * @param signInID
     */
    public void setSignInID(String signInID) {
        this.signInID = signInID;
    }
}
