
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Message/ Transaction Party(s) information. Note that information about parties is intended for business use, it is not intended for transaction authentication and routing of the message.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderListRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PartyType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:ParticipantType" name="Participant" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:RecipientType" name="Recipient" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:SenderType" name="Sender" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PartyType implements Serializable
{
    private List<ParticipantType> participantList = new ArrayList<ParticipantType>();
    private RecipientType recipient;
    private SenderType sender;

    /** 
     * Get the list of 'Participant' element items. Information related to parties relevant to the contents of this message.
     * 
     * @return list
     */
    public List<ParticipantType> getParticipantList() {
        return participantList;
    }

    /** 
     * Set the list of 'Participant' element items. Information related to parties relevant to the contents of this message.
     * 
     * @param list
     */
    public void setParticipantList(List<ParticipantType> list) {
        participantList = list;
    }

    /** 
     * Get the 'Recipient' element value. Information related to the party receiving this message.
     * 
     * @return value
     */
    public RecipientType getRecipient() {
        return recipient;
    }

    /** 
     * Set the 'Recipient' element value. Information related to the party receiving this message.
     * 
     * @param recipient
     */
    public void setRecipient(RecipientType recipient) {
        this.recipient = recipient;
    }

    /** 
     * Get the 'Sender' element value. Information related to the party sending this message.
     * 
     * @return value
     */
    public SenderType getSender() {
        return sender;
    }

    /** 
     * Set the 'Sender' element value. Information related to the party sending this message.
     * 
     * @param sender
     */
    public void setSender(SenderType sender) {
        this.sender = sender;
    }
}
