
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship. Holds the attributes specific to a one booking, from shopping to fulfillment.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderListRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaxType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:ContactInfoType" name="ContactInfo" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:FOID_Type" name="FOID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:IdentityDocType" name="IdentityDoc" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:IndividualType" name="Individual" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:LoyaltyProgramAccountType" name="LoyaltyProgramAccount" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="PaxID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ProfileID_Text" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PaxType implements Serializable
{
    private List<ContactInfoType> contactInfoList = new ArrayList<ContactInfoType>();
    private FOIDType FOID;
    private List<IdentityDocType> identityDocList = new ArrayList<IdentityDocType>();
    private IndividualType individual;
    private List<LoyaltyProgramAccountType> loyaltyProgramAccountList = new ArrayList<LoyaltyProgramAccountType>();
    private String paxID;
    private String profileIDText;

    /** 
     * Get the list of 'ContactInfo' element items. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
     * 
     * @return list
     */
    public List<ContactInfoType> getContactInfoList() {
        return contactInfoList;
    }

    /** 
     * Set the list of 'ContactInfo' element items. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
     * 
     * @param list
     */
    public void setContactInfoList(List<ContactInfoType> list) {
        contactInfoList = list;
    }

    /** 
     * Get the 'FOID' element value. Form of identification.  Typically used to identify that the passenger is who he says he is.  This is the type of FOID as defined in AIRIMP (FF Number, Credit Card Number, etc.).
     * 
     * @return value
     */
    public FOIDType getFOID() {
        return FOID;
    }

    /** 
     * Set the 'FOID' element value. Form of identification.  Typically used to identify that the passenger is who he says he is.  This is the type of FOID as defined in AIRIMP (FF Number, Credit Card Number, etc.).
     * 
     * @param FOID
     */
    public void setFOID(FOIDType FOID) {
        this.FOID = FOID;
    }

    /** 
     * Get the list of 'IdentityDoc' element items. Any document which may be used to identify a person or verify aspects of a person's personal identity. If issued in a small, standard credit card size form, it is usually called an identity card. Some countries issue formal identity documents, while others may require identity verification using informal documents. When the identity document incorporates a person's photograph, it may be called photo ID.  In the absence of a formal identity document, a driver's license may be accepted in many countries for identity verification. Most countries accept passports as a form of identification.
     * 
     * @return list
     */
    public List<IdentityDocType> getIdentityDocList() {
        return identityDocList;
    }

    /** 
     * Set the list of 'IdentityDoc' element items. Any document which may be used to identify a person or verify aspects of a person's personal identity. If issued in a small, standard credit card size form, it is usually called an identity card. Some countries issue formal identity documents, while others may require identity verification using informal documents. When the identity document incorporates a person's photograph, it may be called photo ID.  In the absence of a formal identity document, a driver's license may be accepted in many countries for identity verification. Most countries accept passports as a form of identification.
     * 
     * @param list
     */
    public void setIdentityDocList(List<IdentityDocType> list) {
        identityDocList = list;
    }

    /** 
     * Get the 'Individual' element value. A single human being as distinct from a group, class, or family.
     * 
     * @return value
     */
    public IndividualType getIndividual() {
        return individual;
    }

    /** 
     * Set the 'Individual' element value. A single human being as distinct from a group, class, or family.
     * 
     * @param individual
     */
    public void setIndividual(IndividualType individual) {
        this.individual = individual;
    }

    /** 
     * Get the list of 'LoyaltyProgramAccount' element items. An account set up for a customer within a rewards program which holds funds on behalf of that customer.
     * 
     * @return list
     */
    public List<LoyaltyProgramAccountType> getLoyaltyProgramAccountList() {
        return loyaltyProgramAccountList;
    }

    /** 
     * Set the list of 'LoyaltyProgramAccount' element items. An account set up for a customer within a rewards program which holds funds on behalf of that customer.
     * 
     * @param list
     */
    public void setLoyaltyProgramAccountList(
            List<LoyaltyProgramAccountType> list) {
        loyaltyProgramAccountList = list;
    }

    /** 
     * Get the 'PaxID' element value. Uniquely identifies a Passenger within the context of one message.
     * 
     * @return value
     */
    public String getPaxID() {
        return paxID;
    }

    /** 
     * Set the 'PaxID' element value. Uniquely identifies a Passenger within the context of one message.
     * 
     * @param paxID
     */
    public void setPaxID(String paxID) {
        this.paxID = paxID;
    }

    /** 
     * Get the 'ProfileID_Text' element value. Passenger Profile ID
     * 
     * @return value
     */
    public String getProfileIDText() {
        return profileIDText;
    }

    /** 
     * Set the 'ProfileID_Text' element value. Passenger Profile ID
     * 
     * @param profileIDText
     */
    public void setProfileIDText(String profileIDText) {
        this.profileIDText = profileIDText;
    }
}
