
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rq;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * A device that enables its owner (the cardholder) to make a payment by electronic funds transfer.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderListRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentCardType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CardHolderName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CardIssuerName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CardNumber" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CardProductTypeCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CardSecurityCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:decimal" name="CardSeqNumber" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CardTypeText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CreditCardVendorCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="EffectiveDate" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ExpirationDate" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="MaskedCardID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ReconciliationID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="SellerOwnCardInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TokenizedCardID" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PaymentCardType implements Serializable
{
    private String cardHolderName;
    private String cardIssuerName;
    private String cardNumber;
    private String cardProductTypeCode;
    private String cardSecurityCode;
    private BigDecimal cardSeqNumber;
    private String cardTypeText;
    private String creditCardVendorCode;
    private String effectiveDate;
    private String expirationDate;
    private String maskedCardID;
    private String reconciliationID;
    private Boolean sellerOwnCardInd;
    private String tokenizedCardID;

    /** 
     * Get the 'CardHolderName' element value. Name of credit card holder. Example: JOHN SMITH
     * 
     * @return value
     */
    public String getCardHolderName() {
        return cardHolderName;
    }

    /** 
     * Set the 'CardHolderName' element value. Name of credit card holder. Example: JOHN SMITH
     * 
     * @param cardHolderName
     */
    public void setCardHolderName(String cardHolderName) {
        this.cardHolderName = cardHolderName;
    }

    /** 
     * Get the 'CardIssuerName' element value. Credit card issuing company name.
     * 
     * @return value
     */
    public String getCardIssuerName() {
        return cardIssuerName;
    }

    /** 
     * Set the 'CardIssuerName' element value. Credit card issuing company name.
     * 
     * @param cardIssuerName
     */
    public void setCardIssuerName(String cardIssuerName) {
        this.cardIssuerName = cardIssuerName;
    }

    /** 
     * Get the 'CardNumber' element value. The card number indicated on the payment card.
     * 
     * @return value
     */
    public String getCardNumber() {
        return cardNumber;
    }

    /** 
     * Set the 'CardNumber' element value. The card number indicated on the payment card.
     * 
     * @param cardNumber
     */
    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    /** 
     * Get the 'CardProductTypeCode' element value. Used to specify whether the card is a Consumer (personal) or Commercial (corporate) card.
     * 
     * @return value
     */
    public String getCardProductTypeCode() {
        return cardProductTypeCode;
    }

    /** 
     * Set the 'CardProductTypeCode' element value. Used to specify whether the card is a Consumer (personal) or Commercial (corporate) card.
     * 
     * @param cardProductTypeCode
     */
    public void setCardProductTypeCode(String cardProductTypeCode) {
        this.cardProductTypeCode = cardProductTypeCode;
    }

    /** 
     * Get the 'CardSecurityCode' element value. The verification digits printed on the card following the embossed number.  Example: 123
     * 
     * @return value
     */
    public String getCardSecurityCode() {
        return cardSecurityCode;
    }

    /** 
     * Set the 'CardSecurityCode' element value. The verification digits printed on the card following the embossed number.  Example: 123
     * 
     * @param cardSecurityCode
     */
    public void setCardSecurityCode(String cardSecurityCode) {
        this.cardSecurityCode = cardSecurityCode;
    }

    /** 
     * Get the 'CardSeqNumber' element value. Number displayed on a payment card following the card number which indicates if the card is an original or if it was re-issued with the same card number.
     * 
     * @return value
     */
    public BigDecimal getCardSeqNumber() {
        return cardSeqNumber;
    }

    /** 
     * Set the 'CardSeqNumber' element value. Number displayed on a payment card following the card number which indicates if the card is an original or if it was re-issued with the same card number.
     * 
     * @param cardSeqNumber
     */
    public void setCardSeqNumber(BigDecimal cardSeqNumber) {
        this.cardSeqNumber = cardSeqNumber;
    }

    /** 
     * Get the 'CardTypeText' element value. Magnetic striped card type.
     * 
     * @return value
     */
    public String getCardTypeText() {
        return cardTypeText;
    }

    /** 
     * Set the 'CardTypeText' element value. Magnetic striped card type.
     * 
     * @param cardTypeText
     */
    public void setCardTypeText(String cardTypeText) {
        this.cardTypeText = cardTypeText;
    }

    /** 
     * Get the 'CreditCardVendorCode' element value. Credit card issuer code. Example: MC Note: This is the 2 character code of the credit card issuer.
     * 
     * @return value
     */
    public String getCreditCardVendorCode() {
        return creditCardVendorCode;
    }

    /** 
     * Set the 'CreditCardVendorCode' element value. Credit card issuer code. Example: MC Note: This is the 2 character code of the credit card issuer.
     * 
     * @param creditCardVendorCode
     */
    public void setCreditCardVendorCode(String creditCardVendorCode) {
        this.creditCardVendorCode = creditCardVendorCode;
    }

    /** 
     * Get the 'EffectiveDate' element value. Payment Card Effective Date. Example: 0116
     * 
     * @return value
     */
    public String getEffectiveDate() {
        return effectiveDate;
    }

    /** 
     * Set the 'EffectiveDate' element value. Payment Card Effective Date. Example: 0116
     * 
     * @param effectiveDate
     */
    public void setEffectiveDate(String effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    /** 
     * Get the 'ExpirationDate' element value. The last month of validity Example: 0119
     * 
     * @return value
     */
    public String getExpirationDate() {
        return expirationDate;
    }

    /** 
     * Set the 'ExpirationDate' element value. The last month of validity Example: 0119
     * 
     * @param expirationDate
     */
    public void setExpirationDate(String expirationDate) {
        this.expirationDate = expirationDate;
    }

    /** 
     * Get the 'MaskedCardID' element value. Concealed credit card number, Example: xxxxxxxxxxxx9922
     * 
     * @return value
     */
    public String getMaskedCardID() {
        return maskedCardID;
    }

    /** 
     * Set the 'MaskedCardID' element value. Concealed credit card number, Example: xxxxxxxxxxxx9922
     * 
     * @param maskedCardID
     */
    public void setMaskedCardID(String maskedCardID) {
        this.maskedCardID = maskedCardID;
    }

    /** 
     * Get the 'ReconciliationID' element value. Identifies the individual for this specific transaction when the card is shared (for example, corporate card).  This ID is typically used for payment reconciliation.
     * 
     * @return value
     */
    public String getReconciliationID() {
        return reconciliationID;
    }

    /** 
     * Set the 'ReconciliationID' element value. Identifies the individual for this specific transaction when the card is shared (for example, corporate card).  This ID is typically used for payment reconciliation.
     * 
     * @param reconciliationID
     */
    public void setReconciliationID(String reconciliationID) {
        this.reconciliationID = reconciliationID;
    }

    /** 
     * Get the 'SellerOwnCardInd' element value. When TRUE, indicates the seller is using their own card.  If FALSE, customer card is being used.
     * 
     * @return value
     */
    public Boolean getSellerOwnCardInd() {
        return sellerOwnCardInd;
    }

    /** 
     * Set the 'SellerOwnCardInd' element value. When TRUE, indicates the seller is using their own card.  If FALSE, customer card is being used.
     * 
     * @param sellerOwnCardInd
     */
    public void setSellerOwnCardInd(Boolean sellerOwnCardInd) {
        this.sellerOwnCardInd = sellerOwnCardInd;
    }

    /** 
     * Get the 'TokenizedCardID' element value. An identifier corresponding to a set of payment card details, used between merchant and payment card service provider.
     * 
     * @return value
     */
    public String getTokenizedCardID() {
        return tokenizedCardID;
    }

    /** 
     * Set the 'TokenizedCardID' element value. An identifier corresponding to a set of payment card details, used between merchant and payment card service provider.
     * 
     * @param tokenizedCardID
     */
    public void setTokenizedCardID(String tokenizedCardID) {
        this.tokenizedCardID = tokenizedCardID;
    }
}
