
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rq;

import java.io.Serializable;

/** 
 * Information related to the settlement of a transaction through monetary or other compensations. For example, a payment may be applied to an entire Order or individual Order Items.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderListRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:AmountType" name="Amount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PaymentInfoID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PaymentMethodType" name="PaymentMethod" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PaymentStatusCodeContentType" name="PaymentStatusCode" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PaymentInfoType implements Serializable
{
    private AmountType amount;
    private String paymentInfoID;
    private PaymentMethodType paymentMethod;
    private PaymentStatusCodeContentType paymentStatusCode;

    /** 
     * Get the 'Amount' element value. The amount applied to the associated payment method.  Example: 300 USD
     * 
     * @return value
     */
    public AmountType getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. The amount applied to the associated payment method.  Example: 300 USD
     * 
     * @param amount
     */
    public void setAmount(AmountType amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'PaymentInfoID' element value. Unique identifier for this set of payment information.
     * 
     * @return value
     */
    public String getPaymentInfoID() {
        return paymentInfoID;
    }

    /** 
     * Set the 'PaymentInfoID' element value. Unique identifier for this set of payment information.
     * 
     * @param paymentInfoID
     */
    public void setPaymentInfoID(String paymentInfoID) {
        this.paymentInfoID = paymentInfoID;
    }

    /** 
     * Get the 'PaymentMethod' element value. A form of procedure for the payment of goods or services, plus any transactional information specific to the payment method other than the amount.
     * 
     * @return value
     */
    public PaymentMethodType getPaymentMethod() {
        return paymentMethod;
    }

    /** 
     * Set the 'PaymentMethod' element value. A form of procedure for the payment of goods or services, plus any transactional information specific to the payment method other than the amount.
     * 
     * @param paymentMethod
     */
    public void setPaymentMethod(PaymentMethodType paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    /** 
     * Get the 'PaymentStatusCode' element value. Indicates the current status of this payment information.
     * 
     * @return value
     */
    public PaymentStatusCodeContentType getPaymentStatusCode() {
        return paymentStatusCode;
    }

    /** 
     * Set the 'PaymentStatusCode' element value. Indicates the current status of this payment information.
     * 
     * @param paymentStatusCode
     */
    public void setPaymentStatusCode(
            PaymentStatusCodeContentType paymentStatusCode) {
        this.paymentStatusCode = paymentStatusCode;
    }
}
