
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rq;

import java.io.Serializable;

/** 
 * A form of procedure for the payment of goods or services, plus any transactional information specific to the payment method other than the amount.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderListRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentMethodType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:AccountableDocType" name="AccountableDoc" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:BankAccountType" name="BankAccount" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CashType" name="Cash" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CheckType" name="Check" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DirectBillType" name="DirectBill" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:LoyaltyRedemptionType" name="LoyaltyRedemption" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OtherPaymentMethodType" name="OtherPaymentMethod" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PaymentCardType" name="PaymentCard" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:VoucherType" name="Voucher" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PaymentMethodType implements Serializable
{
    private int choiceSelect = -1;
    private static final int ACCOUNTABLE_DOC_CHOICE = 0;
    private static final int BANK_ACCOUNT_CHOICE = 1;
    private static final int CASH_CHOICE = 2;
    private static final int CHECK_CHOICE = 3;
    private static final int DIRECT_BILL_CHOICE = 4;
    private static final int LOYALTY_REDEMPTION_CHOICE = 5;
    private static final int OTHER_PAYMENT_METHOD_CHOICE = 6;
    private static final int PAYMENT_CARD_CHOICE = 7;
    private static final int VOUCHER_CHOICE = 8;
    private AccountableDocType accountableDoc;
    private BankAccountType bankAccount;
    private CashType cash;
    private CheckType check;
    private DirectBillType directBill;
    private LoyaltyRedemptionType loyaltyRedemption;
    private OtherPaymentMethodType otherPaymentMethod;
    private PaymentCardType paymentCard;
    private VoucherType voucher;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if AccountableDoc is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAccountableDoc() {
        return choiceSelect == ACCOUNTABLE_DOC_CHOICE;
    }

    /** 
     * Get the 'AccountableDoc' element value. Form of payment which utilizes a previously issued accountable travel document (ticket, EMD, coupon, etc.) which has an outstanding credit value.
     * 
     * @return value
     */
    public AccountableDocType getAccountableDoc() {
        return accountableDoc;
    }

    /** 
     * Set the 'AccountableDoc' element value. Form of payment which utilizes a previously issued accountable travel document (ticket, EMD, coupon, etc.) which has an outstanding credit value.
     * 
     * @param accountableDoc
     */
    public void setAccountableDoc(AccountableDocType accountableDoc) {
        setChoiceSelect(ACCOUNTABLE_DOC_CHOICE);
        this.accountableDoc = accountableDoc;
    }

    /** 
     * Check if BankAccount is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifBankAccount() {
        return choiceSelect == BANK_ACCOUNT_CHOICE;
    }

    /** 
     * Get the 'BankAccount' element value. Bank Account payment method definition.  Customer bank accounts for payments, either for paper checks or electronic funds transfer.
     * 
     * @return value
     */
    public BankAccountType getBankAccount() {
        return bankAccount;
    }

    /** 
     * Set the 'BankAccount' element value. Bank Account payment method definition.  Customer bank accounts for payments, either for paper checks or electronic funds transfer.
     * 
     * @param bankAccount
     */
    public void setBankAccount(BankAccountType bankAccount) {
        setChoiceSelect(BANK_ACCOUNT_CHOICE);
        this.bankAccount = bankAccount;
    }

    /** 
     * Check if Cash is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCash() {
        return choiceSelect == CASH_CHOICE;
    }

    /** 
     * Get the 'Cash' element value. Any payment that is collected by the agent and settled between the Airline and the agent. Refer to IATA Resolution 728 Attachment A for full details.
     * 
     * @return value
     */
    public CashType getCash() {
        return cash;
    }

    /** 
     * Set the 'Cash' element value. Any payment that is collected by the agent and settled between the Airline and the agent. Refer to IATA Resolution 728 Attachment A for full details.
     * 
     * @param cash
     */
    public void setCash(CashType cash) {
        setChoiceSelect(CASH_CHOICE);
        this.cash = cash;
    }

    /** 
     * Check if Check is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCheck() {
        return choiceSelect == CHECK_CHOICE;
    }

    /** 
     * Get the 'Check' element value. Personal or bank issued order for transfer of money. Refer to IATA Resolution 728.
     * 
     * @return value
     */
    public CheckType getCheck() {
        return check;
    }

    /** 
     * Set the 'Check' element value. Personal or bank issued order for transfer of money. Refer to IATA Resolution 728.
     * 
     * @param check
     */
    public void setCheck(CheckType check) {
        setChoiceSelect(CHECK_CHOICE);
        this.check = check;
    }

    /** 
     * Check if DirectBill is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDirectBill() {
        return choiceSelect == DIRECT_BILL_CHOICE;
    }

    /** 
     * Get the 'DirectBill' element value. System in which a corporation's travel agency bills employees for their business travel. The employee must then submit an expense accounting and be reimbursed by the corporation.
     * 
     * @return value
     */
    public DirectBillType getDirectBill() {
        return directBill;
    }

    /** 
     * Set the 'DirectBill' element value. System in which a corporation's travel agency bills employees for their business travel. The employee must then submit an expense accounting and be reimbursed by the corporation.
     * 
     * @param directBill
     */
    public void setDirectBill(DirectBillType directBill) {
        setChoiceSelect(DIRECT_BILL_CHOICE);
        this.directBill = directBill;
    }

    /** 
     * Check if LoyaltyRedemption is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifLoyaltyRedemption() {
        return choiceSelect == LOYALTY_REDEMPTION_CHOICE;
    }

    /** 
     * Get the 'LoyaltyRedemption' element value. Loyalty Program currency payment method.
     * 
     * @return value
     */
    public LoyaltyRedemptionType getLoyaltyRedemption() {
        return loyaltyRedemption;
    }

    /** 
     * Set the 'LoyaltyRedemption' element value. Loyalty Program currency payment method.
     * 
     * @param loyaltyRedemption
     */
    public void setLoyaltyRedemption(LoyaltyRedemptionType loyaltyRedemption) {
        setChoiceSelect(LOYALTY_REDEMPTION_CHOICE);
        this.loyaltyRedemption = loyaltyRedemption;
    }

    /** 
     * Check if OtherPaymentMethod is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOtherPaymentMethod() {
        return choiceSelect == OTHER_PAYMENT_METHOD_CHOICE;
    }

    /** 
     * Get the 'OtherPaymentMethod' element value. Other payment method information.
     * 
     * @return value
     */
    public OtherPaymentMethodType getOtherPaymentMethod() {
        return otherPaymentMethod;
    }

    /** 
     * Set the 'OtherPaymentMethod' element value. Other payment method information.
     * 
     * @param otherPaymentMethod
     */
    public void setOtherPaymentMethod(OtherPaymentMethodType otherPaymentMethod) {
        setChoiceSelect(OTHER_PAYMENT_METHOD_CHOICE);
        this.otherPaymentMethod = otherPaymentMethod;
    }

    /** 
     * Check if PaymentCard is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPaymentCard() {
        return choiceSelect == PAYMENT_CARD_CHOICE;
    }

    /** 
     * Get the 'PaymentCard' element value. A device that enables its owner (the cardholder) to make a payment by electronic funds transfer.
     * 
     * @return value
     */
    public PaymentCardType getPaymentCard() {
        return paymentCard;
    }

    /** 
     * Set the 'PaymentCard' element value. A device that enables its owner (the cardholder) to make a payment by electronic funds transfer.
     * 
     * @param paymentCard
     */
    public void setPaymentCard(PaymentCardType paymentCard) {
        setChoiceSelect(PAYMENT_CARD_CHOICE);
        this.paymentCard = paymentCard;
    }

    /** 
     * Check if Voucher is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifVoucher() {
        return choiceSelect == VOUCHER_CHOICE;
    }

    /** 
     * Get the 'Voucher' element value. A document that entitles the holder to a discount or that may be exchanged for goods or services.
     * 
     * @return value
     */
    public VoucherType getVoucher() {
        return voucher;
    }

    /** 
     * Set the 'Voucher' element value. A document that entitles the holder to a discount or that may be exchanged for goods or services.
     * 
     * @param voucher
     */
    public void setVoucher(VoucherType voucher) {
        setChoiceSelect(VOUCHER_CHOICE);
        this.voucher = voucher;
    }
}
