
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rq;

import java.io.Serializable;

/** 
 * Payload information for OrderListRQ.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderListRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RequestType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:OrderFilterCriteriaType" name="OrderFilterCriteria" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OrderListParametersType" name="OrderListParameters" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RequestType implements Serializable
{
    private OrderFilterCriteriaType orderFilterCriteria;
    private OrderListParametersType orderListParameters;

    /** 
     * Get the 'OrderFilterCriteria' element value. Order list request filter criteria.
     * 
     * @return value
     */
    public OrderFilterCriteriaType getOrderFilterCriteria() {
        return orderFilterCriteria;
    }

    /** 
     * Set the 'OrderFilterCriteria' element value. Order list request filter criteria.
     * 
     * @param orderFilterCriteria
     */
    public void setOrderFilterCriteria(
            OrderFilterCriteriaType orderFilterCriteria) {
        this.orderFilterCriteria = orderFilterCriteria;
    }

    /** 
     * Get the 'OrderListParameters' element value. Placeholder for parameter information.
     * 
     * @return value
     */
    public OrderListParametersType getOrderListParameters() {
        return orderListParameters;
    }

    /** 
     * Set the 'OrderListParameters' element value. Placeholder for parameter information.
     * 
     * @param orderListParameters
     */
    public void setOrderListParameters(
            OrderListParametersType orderListParameters) {
        this.orderListParameters = orderListParameters;
    }
}
