
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rq;

import java.io.Serializable;

/** 
 * Information related to the party sending this message.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderListRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SenderType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:AggregatorType" name="Aggregator" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CorporationType" name="Corporation" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:EnabledSystemType" name="EnabledSystem" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CarrierType" name="MarketingCarrier" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CarrierType" name="OperatingCarrier" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CarrierType" name="ORA" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CarrierType" name="POA" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:RetailPartnerType" name="RetailPartner" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:TravelAgencyType" name="TravelAgency" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SenderType implements Serializable
{
    private int choiceSelect = -1;
    private static final int AGGREGATOR_CHOICE = 0;
    private static final int CORPORATION_CHOICE = 1;
    private static final int ENABLED_SYSTEM_CHOICE = 2;
    private static final int MARKETING_CARRIER_CHOICE = 3;
    private static final int OPERATING_CARRIER_CHOICE = 4;
    private static final int ORA_CHOICE = 5;
    private static final int POA_CHOICE = 6;
    private static final int RETAIL_PARTNER_CHOICE = 7;
    private static final int TRAVEL_AGENCY_CHOICE = 8;
    private AggregatorType aggregator;
    private CorporationType corporation;
    private EnabledSystemType enabledSystem;
    private CarrierType marketingCarrier;
    private CarrierType operatingCarrier;
    private CarrierType ORA;
    private CarrierType POA;
    private RetailPartnerType retailPartner;
    private TravelAgencyType travelAgency;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Aggregator is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAggregator() {
        return choiceSelect == AGGREGATOR_CHOICE;
    }

    /** 
     * Get the 'Aggregator' element value. An entity who distributes a Sellerâ€™s shopping request to multiple Airlines and aggregates subsequent responses.
     * 
     * @return value
     */
    public AggregatorType getAggregator() {
        return aggregator;
    }

    /** 
     * Set the 'Aggregator' element value. An entity who distributes a Sellerâ€™s shopping request to multiple Airlines and aggregates subsequent responses.
     * 
     * @param aggregator
     */
    public void setAggregator(AggregatorType aggregator) {
        setChoiceSelect(AGGREGATOR_CHOICE);
        this.aggregator = aggregator;
    }

    /** 
     * Check if Corporation is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCorporation() {
        return choiceSelect == CORPORATION_CHOICE;
    }

    /** 
     * Get the 'Corporation' element value. A company or group of people authorized to act as a single entity (legally a person) and recognized as such in law.
     * 
     * @return value
     */
    public CorporationType getCorporation() {
        return corporation;
    }

    /** 
     * Set the 'Corporation' element value. A company or group of people authorized to act as a single entity (legally a person) and recognized as such in law.
     * 
     * @param corporation
     */
    public void setCorporation(CorporationType corporation) {
        setChoiceSelect(CORPORATION_CHOICE);
        this.corporation = corporation;
    }

    /** 
     * Check if EnabledSystem is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifEnabledSystem() {
        return choiceSelect == ENABLED_SYSTEM_CHOICE;
    }

    /** 
     * Get the 'EnabledSystem' element value. NDC-enabled system.
     * 
     * @return value
     */
    public EnabledSystemType getEnabledSystem() {
        return enabledSystem;
    }

    /** 
     * Set the 'EnabledSystem' element value. NDC-enabled system.
     * 
     * @param enabledSystem
     */
    public void setEnabledSystem(EnabledSystemType enabledSystem) {
        setChoiceSelect(ENABLED_SYSTEM_CHOICE);
        this.enabledSystem = enabledSystem;
    }

    /** 
     * Check if MarketingCarrier is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifMarketingCarrier() {
        return choiceSelect == MARKETING_CARRIER_CHOICE;
    }

    /** 
     * Get the 'MarketingCarrier' element value. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * 
     * @return value
     */
    public CarrierType getMarketingCarrier() {
        return marketingCarrier;
    }

    /** 
     * Set the 'MarketingCarrier' element value. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * 
     * @param marketingCarrier
     */
    public void setMarketingCarrier(CarrierType marketingCarrier) {
        setChoiceSelect(MARKETING_CARRIER_CHOICE);
        this.marketingCarrier = marketingCarrier;
    }

    /** 
     * Check if OperatingCarrier is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOperatingCarrier() {
        return choiceSelect == OPERATING_CARRIER_CHOICE;
    }

    /** 
     * Get the 'OperatingCarrier' element value. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * 
     * @return value
     */
    public CarrierType getOperatingCarrier() {
        return operatingCarrier;
    }

    /** 
     * Set the 'OperatingCarrier' element value. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * 
     * @param operatingCarrier
     */
    public void setOperatingCarrier(CarrierType operatingCarrier) {
        setChoiceSelect(OPERATING_CARRIER_CHOICE);
        this.operatingCarrier = operatingCarrier;
    }

    /** 
     * Check if ORA is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifORA() {
        return choiceSelect == ORA_CHOICE;
    }

    /** 
     * Get the 'ORA' element value. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * 
     * @return value
     */
    public CarrierType getORA() {
        return ORA;
    }

    /** 
     * Set the 'ORA' element value. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * 
     * @param ORA
     */
    public void setORA(CarrierType ORA) {
        setChoiceSelect(ORA_CHOICE);
        this.ORA = ORA;
    }

    /** 
     * Check if POA is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPOA() {
        return choiceSelect == POA_CHOICE;
    }

    /** 
     * Get the 'POA' element value. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * 
     * @return value
     */
    public CarrierType getPOA() {
        return POA;
    }

    /** 
     * Set the 'POA' element value. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * 
     * @param POA
     */
    public void setPOA(CarrierType POA) {
        setChoiceSelect(POA_CHOICE);
        this.POA = POA;
    }

    /** 
     * Check if RetailPartner is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifRetailPartner() {
        return choiceSelect == RETAIL_PARTNER_CHOICE;
    }

    /** 
     * Get the 'RetailPartner' element value. A company that partners with a manufacturer or producer to market and sell the manufacturer's products, services, or technologies.
     * 
     * @return value
     */
    public RetailPartnerType getRetailPartner() {
        return retailPartner;
    }

    /** 
     * Set the 'RetailPartner' element value. A company that partners with a manufacturer or producer to market and sell the manufacturer's products, services, or technologies.
     * 
     * @param retailPartner
     */
    public void setRetailPartner(RetailPartnerType retailPartner) {
        setChoiceSelect(RETAIL_PARTNER_CHOICE);
        this.retailPartner = retailPartner;
    }

    /** 
     * Check if TravelAgency is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTravelAgency() {
        return choiceSelect == TRAVEL_AGENCY_CHOICE;
    }

    /** 
     * Get the 'TravelAgency' element value. A private retailer or public service that provides travel and tourism related services to the public on behalf of suppliers such as activities, airlines, car rentals, cruise lines, hotels, railways, travel insurance, and package tours.
     * 
     * @return value
     */
    public TravelAgencyType getTravelAgency() {
        return travelAgency;
    }

    /** 
     * Set the 'TravelAgency' element value. A private retailer or public service that provides travel and tourism related services to the public on behalf of suppliers such as activities, airlines, car rentals, cruise lines, hotels, railways, travel insurance, and package tours.
     * 
     * @param travelAgency
     */
    public void setTravelAgency(TravelAgencyType travelAgency) {
        setChoiceSelect(TRAVEL_AGENCY_CHOICE);
        this.travelAgency = travelAgency;
    }
}
