
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rq;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * The accountable document issued by or on behalf of a carrier which includes notices and the flight and passenger coupons contained therein.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderListRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:decimal" name="CouponNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CouponStatusCode" minOccurs="0"/>
 *     &lt;xs:element type="ns:DateRangeType" name="IssueDateRange" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TicketingLocationCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TicketNumber" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TicketType implements Serializable
{
    private BigDecimal couponNumber;
    private String couponStatusCode;
    private DateRangeType issueDateRange;
    private String ticketingLocationCode;
    private String ticketNumber;

    /** 
     * Get the 'CouponNumber' element value. Number assigned to the issued coupon.
     * 
     * @return value
     */
    public BigDecimal getCouponNumber() {
        return couponNumber;
    }

    /** 
     * Set the 'CouponNumber' element value. Number assigned to the issued coupon.
     * 
     * @param couponNumber
     */
    public void setCouponNumber(BigDecimal couponNumber) {
        this.couponNumber = couponNumber;
    }

    /** 
     * Get the 'CouponStatusCode' element value. Current status of the flight/ value coupon.  Example: E (Exchanged/Reissued)
     * 
     * @return value
     */
    public String getCouponStatusCode() {
        return couponStatusCode;
    }

    /** 
     * Set the 'CouponStatusCode' element value. Current status of the flight/ value coupon.  Example: E (Exchanged/Reissued)
     * 
     * @param couponStatusCode
     */
    public void setCouponStatusCode(String couponStatusCode) {
        this.couponStatusCode = couponStatusCode;
    }

    /** 
     * Get the 'IssueDateRange' element value. Issue date range
     * 
     * @return value
     */
    public DateRangeType getIssueDateRange() {
        return issueDateRange;
    }

    /** 
     * Set the 'IssueDateRange' element value. Issue date range
     * 
     * @param issueDateRange
     */
    public void setIssueDateRange(DateRangeType issueDateRange) {
        this.issueDateRange = issueDateRange;
    }

    /** 
     * Get the 'TicketingLocationCode' element value. IATA defined code identifying a city or station.
     * 
     * @return value
     */
    public String getTicketingLocationCode() {
        return ticketingLocationCode;
    }

    /** 
     * Set the 'TicketingLocationCode' element value. IATA defined code identifying a city or station.
     * 
     * @param ticketingLocationCode
     */
    public void setTicketingLocationCode(String ticketingLocationCode) {
        this.ticketingLocationCode = ticketingLocationCode;
    }

    /** 
     * Get the 'TicketNumber' element value. The document number comprised of the airline code, form code, and serial number.
     * 
     * @return value
     */
    public String getTicketNumber() {
        return ticketNumber;
    }

    /** 
     * Set the 'TicketNumber' element value. The document number comprised of the airline code, form code, and serial number.
     * 
     * @param ticketNumber
     */
    public void setTicketNumber(String ticketNumber) {
        this.ticketNumber = ticketNumber;
    }
}
