
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A single human being as distinct from a group, class, or family.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderListRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="IndividualType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="GivenName" minOccurs="0" maxOccurs="5"/>
 *     &lt;xs:element type="xs:string" name="IndividualID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="MiddleName" minOccurs="0" maxOccurs="3"/>
 *     &lt;xs:element type="xs:string" name="Surname" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class IndividualType implements Serializable
{
    private List<String> givenNameList = new ArrayList<String>();
    private String individualID;
    private List<String> middleNameList = new ArrayList<String>();
    private String surname;

    /** 
     * Get the list of 'GivenName' element items. A personal name given to the individual at birthÂ and used before aÂ family name. Also called first name. E.g. JOHN.
     * 
     * @return list
     */
    public List<String> getGivenNameList() {
        return givenNameList;
    }

    /** 
     * Set the list of 'GivenName' element items. A personal name given to the individual at birthÂ and used before aÂ family name. Also called first name. E.g. JOHN.
     * 
     * @param list
     */
    public void setGivenNameList(List<String> list) {
        givenNameList = list;
    }

    /** 
     * Get the 'IndividualID' element value. Uniquely Identifies an Individual within the context of one message.
     * 
     * @return value
     */
    public String getIndividualID() {
        return individualID;
    }

    /** 
     * Set the 'IndividualID' element value. Uniquely Identifies an Individual within the context of one message.
     * 
     * @param individualID
     */
    public void setIndividualID(String individualID) {
        this.individualID = individualID;
    }

    /** 
     * Get the list of 'MiddleName' element items. Individual's middle name or initial.  E.g. G, GEORGE.
     * 
     * @return list
     */
    public List<String> getMiddleNameList() {
        return middleNameList;
    }

    /** 
     * Set the list of 'MiddleName' element items. Individual's middle name or initial.  E.g. G, GEORGE.
     * 
     * @param list
     */
    public void setMiddleNameList(List<String> list) {
        middleNameList = list;
    }

    /** 
     * Get the 'Surname' element value. Individual's hereditaryÂ name(s) common to all members of a family. Also known as family name or last name. E.g. SMITH. Excludes any potential suffix.
     * 
     * @return value
     */
    public String getSurname() {
        return surname;
    }

    /** 
     * Set the 'Surname' element value. Individual's hereditaryÂ name(s) common to all members of a family. Also known as family name or last name. E.g. SMITH. Excludes any potential suffix.
     * 
     * @param surname
     */
    public void setSurname(String surname) {
        this.surname = surname;
    }
}
