
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rs;

import java.io.Serializable;

/** 
 * List of Order IDs and order information which match the Filter Criteria specified in OrderListRQ.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderListRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MatchedOrderType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:ArrivalType" name="Arrival" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DepType" name="Dep" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DateTimeType" name="CreationDateTime" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DateTimeType" name="LastModifiedDateTime" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="OrderRefID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OrderStatusCodeContentType" name="OrderStatusCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PaxsType" name="Paxs" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TicketingStatusCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:TravelAgencyType" name="TravelAgency" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class MatchedOrderType implements Serializable
{
    private ArrivalType arrival;
    private DepType dep;
    private DateTimeType creationDateTime;
    private DateTimeType lastModifiedDateTime;
    private String orderRefID;
    private OrderStatusCodeContentType orderStatusCode;
    private PaxsType paxs;
    private String ticketingStatusCode;
    private TravelAgencyType travelAgency;

    /** 
     * Get the 'Arrival' element value. Journey Arrival information related to the specified Order.
     * 
     * @return value
     */
    public ArrivalType getArrival() {
        return arrival;
    }

    /** 
     * Set the 'Arrival' element value. Journey Arrival information related to the specified Order.
     * 
     * @param arrival
     */
    public void setArrival(ArrivalType arrival) {
        this.arrival = arrival;
    }

    /** 
     * Get the 'Dep' element value. Journey departure information related to the specified Order.
     * 
     * @return value
     */
    public DepType getDep() {
        return dep;
    }

    /** 
     * Set the 'Dep' element value. Journey departure information related to the specified Order.
     * 
     * @param dep
     */
    public void setDep(DepType dep) {
        this.dep = dep;
    }

    /** 
     * Get the 'CreationDateTime' element value. Date at which the Order was created.
     * 
     * @return value
     */
    public DateTimeType getCreationDateTime() {
        return creationDateTime;
    }

    /** 
     * Set the 'CreationDateTime' element value. Date at which the Order was created.
     * 
     * @param creationDateTime
     */
    public void setCreationDateTime(DateTimeType creationDateTime) {
        this.creationDateTime = creationDateTime;
    }

    /** 
     * Get the 'LastModifiedDateTime' element value. Date at which the Order was created.
     * 
     * @return value
     */
    public DateTimeType getLastModifiedDateTime() {
        return lastModifiedDateTime;
    }

    /** 
     * Set the 'LastModifiedDateTime' element value. Date at which the Order was created.
     * 
     * @param lastModifiedDateTime
     */
    public void setLastModifiedDateTime(DateTimeType lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
    }

    /** 
     * Get the 'OrderRefID' element value. Reference to an Order's Order ID.
     * 
     * @return value
     */
    public String getOrderRefID() {
        return orderRefID;
    }

    /** 
     * Set the 'OrderRefID' element value. Reference to an Order's Order ID.
     * 
     * @param orderRefID
     */
    public void setOrderRefID(String orderRefID) {
        this.orderRefID = orderRefID;
    }

    /** 
     * Get the 'OrderStatusCode' element value. Indicates the current status of an Order E.g. OK (Confirmed)
     * 
     * @return value
     */
    public OrderStatusCodeContentType getOrderStatusCode() {
        return orderStatusCode;
    }

    /** 
     * Set the 'OrderStatusCode' element value. Indicates the current status of an Order E.g. OK (Confirmed)
     * 
     * @param orderStatusCode
     */
    public void setOrderStatusCode(OrderStatusCodeContentType orderStatusCode) {
        this.orderStatusCode = orderStatusCode;
    }

    /** 
     * Get the 'Paxs' element value. Passenger and Group information.
     * 
     * @return value
     */
    public PaxsType getPaxs() {
        return paxs;
    }

    /** 
     * Set the 'Paxs' element value. Passenger and Group information.
     * 
     * @param paxs
     */
    public void setPaxs(PaxsType paxs) {
        this.paxs = paxs;
    }

    /** 
     * Get the 'TicketingStatusCode' element value. Ticketing Status. Examples: Requested, Ticketed, Other
     * 
     * @return value
     */
    public String getTicketingStatusCode() {
        return ticketingStatusCode;
    }

    /** 
     * Set the 'TicketingStatusCode' element value. Ticketing Status. Examples: Requested, Ticketed, Other
     * 
     * @param ticketingStatusCode
     */
    public void setTicketingStatusCode(String ticketingStatusCode) {
        this.ticketingStatusCode = ticketingStatusCode;
    }

    /** 
     * Get the 'TravelAgency' element value. A private retailer or public service that provides travel and tourism related services to the public on behalf of suppliers such as activities, airlines, car rentals, cruise lines, hotels, railways, travel insurance, and package tours.
     * 
     * @return value
     */
    public TravelAgencyType getTravelAgency() {
        return travelAgency;
    }

    /** 
     * Set the 'TravelAgency' element value. A private retailer or public service that provides travel and tourism related services to the public on behalf of suppliers such as activities, airlines, car rentals, cruise lines, hotels, railways, travel insurance, and package tours.
     * 
     * @param travelAgency
     */
    public void setTravelAgency(TravelAgencyType travelAgency) {
        this.travelAgency = travelAgency;
    }
}
