
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Passenger and Group information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderListRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaxsType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:PaxType" name="Pax" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:PaxGroupType" name="PaxGroup" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PaxsType implements Serializable
{
    private List<PaxType> paxList = new ArrayList<PaxType>();
    private PaxGroupType paxGroup;

    /** 
     * Get the list of 'Pax' element items. Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship. Holds the attributes specific to a one booking, from shopping to fulfillment.
     * 
     * @return list
     */
    public List<PaxType> getPaxList() {
        return paxList;
    }

    /** 
     * Set the list of 'Pax' element items. Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship. Holds the attributes specific to a one booking, from shopping to fulfillment.
     * 
     * @param list
     */
    public void setPaxList(List<PaxType> list) {
        paxList = list;
    }

    /** 
     * Get the 'PaxGroup' element value. A number of individual passengers traveling under one commercial name that associates them. E.g. a Tour group or a group for sales allotment from airline to agency.
     * 
     * @return value
     */
    public PaxGroupType getPaxGroup() {
        return paxGroup;
    }

    /** 
     * Set the 'PaxGroup' element value. A number of individual passengers traveling under one commercial name that associates them. E.g. a Tour group or a group for sales allotment from airline to agency.
     * 
     * @param paxGroup
     */
    public void setPaxGroup(PaxGroupType paxGroup) {
        this.paxGroup = paxGroup;
    }
}
