
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * response to a queue list
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://xml.amadeus.com/QDQLRR_11_1_1A" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Queue_ListReply">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="errorReturn" minOccurs="0">
 *         &lt;!-- Reference to inner class ErrorReturn -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="queueView" minOccurs="0">
 *         &lt;!-- Reference to inner class QueueView -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class QueueListReply implements Serializable
{
    private ErrorReturn errorReturn;
    private QueueView queueView;

    /** 
     * Get the 'errorReturn' element value.
     * 
     * @return value
     */
    public ErrorReturn getErrorReturn() {
        return errorReturn;
    }

    /** 
     * Set the 'errorReturn' element value.
     * 
     * @param errorReturn
     */
    public void setErrorReturn(ErrorReturn errorReturn) {
        this.errorReturn = errorReturn;
    }

    /** 
     * Get the 'queueView' element value.
     * 
     * @return value
     */
    public QueueView getQueueView() {
        return queueView;
    }

    /** 
     * Set the 'queueView' element value.
     * 
     * @param queueView
     */
    public void setQueueView(QueueView queueView) {
        this.queueView = queueView;
    }
    /** 
     * any errors should be returned in this group
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://xml.amadeus.com/QDQLRR_11_1_1A" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="errorReturn" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:ApplicationErrorInformationTypeI" name="errorDefinition"/>
     *       &lt;xs:element type="ns:FreeTextInformationType" name="errorText" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ErrorReturn implements Serializable
    {
        private ApplicationErrorInformationTypeI errorDefinition;
        private FreeTextInformationType errorText;

        /** 
         * Get the 'errorDefinition' element value. returns the error code
         * 
         * @return value
         */
        public ApplicationErrorInformationTypeI getErrorDefinition() {
            return errorDefinition;
        }

        /** 
         * Set the 'errorDefinition' element value. returns the error code
         * 
         * @param errorDefinition
         */
        public void setErrorDefinition(
                ApplicationErrorInformationTypeI errorDefinition) {
            this.errorDefinition = errorDefinition;
        }

        /** 
         * Get the 'errorText' element value. free text for the error
         * 
         * @return value
         */
        public FreeTextInformationType getErrorText() {
            return errorText;
        }

        /** 
         * Set the 'errorText' element value. free text for the error
         * 
         * @param errorText
         */
        public void setErrorText(FreeTextInformationType errorText) {
            this.errorText = errorText;
        }
    }
    /** 
     * target office, counts and the PNR details
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://xml.amadeus.com/QDQLRR_11_1_1A" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="queueView" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:AdditionalBusinessSourceInformationType" name="agent"/>
     *       &lt;xs:element type="ns:QueueInformationTypeI" name="queueNumber"/>
     *       &lt;xs:element type="ns:SubQueueInformationTypeI" name="categoryDetails"/>
     *       &lt;xs:element type="ns:StructuredDateTimeInformationType" name="date" minOccurs="0"/>
     *       &lt;xs:element type="ns:NumberOfUnitsType" name="pnrCount" maxOccurs="3"/>
     *       &lt;xs:element name="item" maxOccurs="1000">
     *         &lt;!-- Reference to inner class Item -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class QueueView implements Serializable
    {
        private AdditionalBusinessSourceInformationType agent;
        private QueueInformationTypeI queueNumber;
        private SubQueueInformationTypeI categoryDetails;
        private StructuredDateTimeInformationType date;
        private List<NumberOfUnitsType> pnrCountList = new ArrayList<NumberOfUnitsType>();
        private List<Item> itemList = new ArrayList<Item>();

        /** 
         * Get the 'agent' element value. details of who queue placed the PNR
         * 
         * @return value
         */
        public AdditionalBusinessSourceInformationType getAgent() {
            return agent;
        }

        /** 
         * Set the 'agent' element value. details of who queue placed the PNR
         * 
         * @param agent
         */
        public void setAgent(AdditionalBusinessSourceInformationType agent) {
            this.agent = agent;
        }

        /** 
         * Get the 'queueNumber' element value. queue being displayed
         * 
         * @return value
         */
        public QueueInformationTypeI getQueueNumber() {
            return queueNumber;
        }

        /** 
         * Set the 'queueNumber' element value. queue being displayed
         * 
         * @param queueNumber
         */
        public void setQueueNumber(QueueInformationTypeI queueNumber) {
            this.queueNumber = queueNumber;
        }

        /** 
         * Get the 'categoryDetails' element value. category and date range
         * 
         * @return value
         */
        public SubQueueInformationTypeI getCategoryDetails() {
            return categoryDetails;
        }

        /** 
         * Set the 'categoryDetails' element value. category and date range
         * 
         * @param categoryDetails
         */
        public void setCategoryDetails(SubQueueInformationTypeI categoryDetails) {
            this.categoryDetails = categoryDetails;
        }

        /** 
         * Get the 'date' element value. date range
         * 
         * @return value
         */
        public StructuredDateTimeInformationType getDate() {
            return date;
        }

        /** 
         * Set the 'date' element value. date range
         * 
         * @param date
         */
        public void setDate(StructuredDateTimeInformationType date) {
            this.date = date;
        }

        /** 
         * Get the list of 'pnrCount' element items. all 3 occurences are mandatory and show in order number of  1)PNRs on queue 2)PNRs found 3)PNRs scanned
         * 
         * @return list
         */
        public List<NumberOfUnitsType> getPnrCountList() {
            return pnrCountList;
        }

        /** 
         * Set the list of 'pnrCount' element items. all 3 occurences are mandatory and show in order number of  1)PNRs on queue 2)PNRs found 3)PNRs scanned
         * 
         * @param list
         */
        public void setPnrCountList(List<NumberOfUnitsType> list) {
            pnrCountList = list;
        }

        /** 
         * Get the list of 'item' element items.
         * 
         * @return list
         */
        public List<Item> getItemList() {
            return itemList;
        }

        /** 
         * Set the list of 'item' element items.
         * 
         * @param list
         */
        public void setItemList(List<Item> list) {
            itemList = list;
        }
        /** 
         * 1 item for each PNR to be listed
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://xml.amadeus.com/QDQLRR_11_1_1A" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="item" maxOccurs="1000">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:TravellerInformationTypeI" name="paxName"/>
         *       &lt;xs:element type="ns:ReservationControlInformationTypeI" name="recLoc"/>
         *       &lt;xs:element type="ns:TravelProductInformationTypeI" name="segment" minOccurs="0"/>
         *       &lt;xs:element type="ns:AdditionalBusinessSourceInformationType" name="agent"/>
         *       &lt;xs:element type="ns:StructuredDateTimeInformationType_181906S" name="pnrdates" maxOccurs="3"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Item implements Serializable
        {
            private TravellerInformationTypeI paxName;
            private ReservationControlInformationTypeI recLoc;
            private TravelProductInformationTypeI segment;
            private AdditionalBusinessSourceInformationType agent;
            private List<StructuredDateTimeInformationType181906S> pnrdateList = new ArrayList<StructuredDateTimeInformationType181906S>();

            /** 
             * Get the 'paxName' element value. surname of the passenger only or GROUP for a group PNR
             * 
             * @return value
             */
            public TravellerInformationTypeI getPaxName() {
                return paxName;
            }

            /** 
             * Set the 'paxName' element value. surname of the passenger only or GROUP for a group PNR
             * 
             * @param paxName
             */
            public void setPaxName(TravellerInformationTypeI paxName) {
                this.paxName = paxName;
            }

            /** 
             * Get the 'recLoc' element value. record locator
             * 
             * @return value
             */
            public ReservationControlInformationTypeI getRecLoc() {
                return recLoc;
            }

            /** 
             * Set the 'recLoc' element value. record locator
             * 
             * @param recLoc
             */
            public void setRecLoc(ReservationControlInformationTypeI recLoc) {
                this.recLoc = recLoc;
            }

            /** 
             * Get the 'segment' element value. 1st segment found in the PNR - if there is data to send
             * 
             * @return value
             */
            public TravelProductInformationTypeI getSegment() {
                return segment;
            }

            /** 
             * Set the 'segment' element value. 1st segment found in the PNR - if there is data to send
             * 
             * @param segment
             */
            public void setSegment(TravelProductInformationTypeI segment) {
                this.segment = segment;
            }

            /** 
             * Get the 'agent' element value. details of who queue placed the PNR
             * 
             * @return value
             */
            public AdditionalBusinessSourceInformationType getAgent() {
                return agent;
            }

            /** 
             * Set the 'agent' element value. details of who queue placed the PNR
             * 
             * @param agent
             */
            public void setAgent(AdditionalBusinessSourceInformationType agent) {
                this.agent = agent;
            }

            /** 
             * Get the list of 'pnrdates' element items. contains 1,2 or 3 of the following Queue placement date/time Ticketing date PNR creation date
             * 
             * @return list
             */
            public List<StructuredDateTimeInformationType181906S> getPnrdateList() {
                return pnrdateList;
            }

            /** 
             * Set the list of 'pnrdates' element items. contains 1,2 or 3 of the following Queue placement date/time Ticketing date PNR creation date
             * 
             * @param list
             */
            public void setPnrdateList(
                    List<StructuredDateTimeInformationType181906S> list) {
                pnrdateList = list;
            }
        }
    }
}
