
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Payload information for OrderListRS.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderListRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ResponseType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:MatchedOrderType" name="MatchedOrder" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:OrderListProcessingType" name="OrderListProcessing" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:WarningType" name="Warning" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ResponseType implements Serializable
{
    private List<MatchedOrderType> matchedOrderList = new ArrayList<MatchedOrderType>();
    private OrderListProcessingType orderListProcessing;
    private List<WarningType> warningList = new ArrayList<WarningType>();

    /** 
     * Get the list of 'MatchedOrder' element items. List of Order IDs and order information which match the Filter Criteria specified in OrderListRQ.
     * 
     * @return list
     */
    public List<MatchedOrderType> getMatchedOrderList() {
        return matchedOrderList;
    }

    /** 
     * Set the list of 'MatchedOrder' element items. List of Order IDs and order information which match the Filter Criteria specified in OrderListRQ.
     * 
     * @param list
     */
    public void setMatchedOrderList(List<MatchedOrderType> list) {
        matchedOrderList = list;
    }

    /** 
     * Get the 'OrderListProcessing' element value. Placeholder for processing information.
     * 
     * @return value
     */
    public OrderListProcessingType getOrderListProcessing() {
        return orderListProcessing;
    }

    /** 
     * Set the 'OrderListProcessing' element value. Placeholder for processing information.
     * 
     * @param orderListProcessing
     */
    public void setOrderListProcessing(
            OrderListProcessingType orderListProcessing) {
        this.orderListProcessing = orderListProcessing;
    }

    /** 
     * Get the list of 'Warning' element items. Contains information related to potential business errors detected during processing of the preceding request.
     * 
     * @return list
     */
    public List<WarningType> getWarningList() {
        return warningList;
    }

    /** 
     * Set the list of 'Warning' element items. Contains information related to potential business errors detected during processing of the preceding request.
     * 
     * @param list
     */
    public void setWarningList(List<WarningType> list) {
        warningList = list;
    }
}
