
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rs;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Store date and time in a structured way
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://xml.amadeus.com/QDQLRR_11_1_1A" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StructuredDateTimeType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="year"/>
 *     &lt;xs:element type="xs:integer" name="month"/>
 *     &lt;xs:element type="xs:integer" name="day"/>
 *     &lt;xs:element type="xs:string" name="hour" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="minutes" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class StructuredDateTimeType implements Serializable
{
    private String year;
    private BigInteger month;
    private BigInteger day;
    private String hour;
    private String minutes;

    /** 
     * Get the 'year' element value. Year number.
     * 
     * @return value
     */
    public String getYear() {
        return year;
    }

    /** 
     * Set the 'year' element value. Year number.
     * 
     * @param year
     */
    public void setYear(String year) {
        this.year = year;
    }

    /** 
     * Get the 'month' element value. Month number of the year (1 being first month, 0 being NULL data)
     * 
     * @return value
     */
    public BigInteger getMonth() {
        return month;
    }

    /** 
     * Set the 'month' element value. Month number of the year (1 being first month, 0 being NULL data)
     * 
     * @param month
     */
    public void setMonth(BigInteger month) {
        this.month = month;
    }

    /** 
     * Get the 'day' element value. day number of the month (1 being first day of the month, 0 is null data)
     * 
     * @return value
     */
    public BigInteger getDay() {
        return day;
    }

    /** 
     * Set the 'day' element value. day number of the month (1 being first day of the month, 0 is null data)
     * 
     * @param day
     */
    public void setDay(BigInteger day) {
        this.day = day;
    }

    /** 
     * Get the 'hour' element value. Hour between 0 and 23
     * 
     * @return value
     */
    public String getHour() {
        return hour;
    }

    /** 
     * Set the 'hour' element value. Hour between 0 and 23
     * 
     * @param hour
     */
    public void setHour(String hour) {
        this.hour = hour;
    }

    /** 
     * Get the 'minutes' element value. Minutes between 0 and 59
     * 
     * @return value
     */
    public String getMinutes() {
        return minutes;
    }

    /** 
     * Set the 'minutes' element value. Minutes between 0 and 59
     * 
     * @param minutes
     */
    public void setMinutes(String minutes) {
        this.minutes = minutes;
    }
}
