
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rs;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Identification of the surname of a traveller, the type of traveller, number of travellers per surname and the action to be taken.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://xml.amadeus.com/QDQLRR_11_1_1A" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravellerSurnameInformationTypeI">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="surname"/>
 *     &lt;xs:element type="xs:string" name="type" minOccurs="0"/>
 *     &lt;xs:element type="xs:integer" name="quantity" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TravellerSurnameInformationTypeI implements Serializable
{
    private String surname;
    private String type;
    private BigInteger quantity;

    /** 
     * Get the 'surname' element value. surname of the passenger or GROUP for a group PNR
     * 
     * @return value
     */
    public String getSurname() {
        return surname;
    }

    /** 
     * Set the 'surname' element value. surname of the passenger or GROUP for a group PNR
     * 
     * @param surname
     */
    public void setSurname(String surname) {
        this.surname = surname;
    }

    /** 
     * Get the 'type' element value.
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'type' element value.
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /** 
     * Get the 'quantity' element value.
     * 
     * @return value
     */
    public BigInteger getQuantity() {
        return quantity;
    }

    /** 
     * Set the 'quantity' element value.
     * 
     * @param quantity
     */
    public void setQuantity(BigInteger quantity) {
        this.quantity = quantity;
    }
}
