
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Column within a Cabin used to identify Seats and Cabin Components within a Row.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CabinColumnType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CharacteristicCode" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element type="xs:string" name="ColumnID" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CabinColumnType implements Serializable
{
    private List<String> characteristicCodeList = new ArrayList<String>();
    private String columnID;

    /** 
     * Get the list of 'CharacteristicCode' element items. Column characteristic/property code (e.g. A - Aisle, W - Window, etc.).
     * 
     * @return list
     */
    public List<String> getCharacteristicCodeList() {
        return characteristicCodeList;
    }

    /** 
     * Set the list of 'CharacteristicCode' element items. Column characteristic/property code (e.g. A - Aisle, W - Window, etc.).
     * 
     * @param list
     */
    public void setCharacteristicCodeList(List<String> list) {
        characteristicCodeList = list;
    }

    /** 
     * Get the 'ColumnID' element value. Identifier of the column (e.g. A, B, C, etc.).
     * 
     * @return value
     */
    public String getColumnID() {
        return columnID;
    }

    /** 
     * Set the 'ColumnID' element value. Identifier of the column (e.g. A, B, C, etc.).
     * 
     * @param columnID
     */
    public void setColumnID(String columnID) {
        this.columnID = columnID;
    }
}
