
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;

/** 
 * Any payment that is collected by the agent and settled between the Airline and the agent. Refer to IATA Resolution 728 Attachment A for full details.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CashType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:PostalAddressType" name="CollectionAddress" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ReceiptID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TerminalID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:TravelAgentType" name="TravelAgent" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CashType implements Serializable
{
    private PostalAddressType collectionAddress;
    private String receiptID;
    private String terminalID;
    private TravelAgentType travelAgent;

    /** 
     * Get the 'CollectionAddress' element value. Natural or physical address used for postal service. May be a building address, airport address, etc.
     * 
     * @return value
     */
    public PostalAddressType getCollectionAddress() {
        return collectionAddress;
    }

    /** 
     * Set the 'CollectionAddress' element value. Natural or physical address used for postal service. May be a building address, airport address, etc.
     * 
     * @param collectionAddress
     */
    public void setCollectionAddress(PostalAddressType collectionAddress) {
        this.collectionAddress = collectionAddress;
    }

    /** 
     * Get the 'ReceiptID' element value. Cash receipt ID. Example: 121717H47S
     * 
     * @return value
     */
    public String getReceiptID() {
        return receiptID;
    }

    /** 
     * Set the 'ReceiptID' element value. Cash receipt ID. Example: 121717H47S
     * 
     * @param receiptID
     */
    public void setReceiptID(String receiptID) {
        this.receiptID = receiptID;
    }

    /** 
     * Get the 'TerminalID' element value. Terminal ID where cash was collected. Example: QP776611
     * 
     * @return value
     */
    public String getTerminalID() {
        return terminalID;
    }

    /** 
     * Set the 'TerminalID' element value. Terminal ID where cash was collected. Example: QP776611
     * 
     * @param terminalID
     */
    public void setTerminalID(String terminalID) {
        this.terminalID = terminalID;
    }

    /** 
     * Get the 'TravelAgent' element value. A private retailer or public service individual that provides travel and tourism related services to the public on behalf of suppliers such as activities, airlines, car rentals, cruise lines, hotels, railways, travel insurance, and package tours.
     * 
     * @return value
     */
    public TravelAgentType getTravelAgent() {
        return travelAgent;
    }

    /** 
     * Set the 'TravelAgent' element value. A private retailer or public service individual that provides travel and tourism related services to the public on behalf of suppliers such as activities, airlines, car rentals, cruise lines, hotels, railways, travel insurance, and package tours.
     * 
     * @param travelAgent
     */
    public void setTravelAgent(TravelAgentType travelAgent) {
        this.travelAgent = travelAgent;
    }
}
