
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;

/** 
 * A written order instructing a financial institution to pay immediately on demand a specified amount of money from the check writer's account to the person named on the check or, if a specific person is not named, to whoever bears the check to the institution for payment.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CheckType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:decimal" name="CheckNumber" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PayeeName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:date" name="SignedDate" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CheckType implements Serializable
{
    private BigDecimal checkNumber;
    private String payeeName;
    private Date signedDate;

    /** 
     * Get the 'CheckNumber' element value. Number found on the check which uniquely identifies the check being used as payment.
     * 
     * @return value
     */
    public BigDecimal getCheckNumber() {
        return checkNumber;
    }

    /** 
     * Set the 'CheckNumber' element value. Number found on the check which uniquely identifies the check being used as payment.
     * 
     * @param checkNumber
     */
    public void setCheckNumber(BigDecimal checkNumber) {
        this.checkNumber = checkNumber;
    }

    /** 
     * Get the 'PayeeName' element value. The name of the payee or check recipient.
     * 
     * @return value
     */
    public String getPayeeName() {
        return payeeName;
    }

    /** 
     * Set the 'PayeeName' element value. The name of the payee or check recipient.
     * 
     * @param payeeName
     */
    public void setPayeeName(String payeeName) {
        this.payeeName = payeeName;
    }

    /** 
     * Get the 'SignedDate' element value. Date that the check is signed.
     * 
     * @return value
     */
    public Date getSignedDate() {
        return signedDate;
    }

    /** 
     * Set the 'SignedDate' element value. Date that the check is signed.
     * 
     * @param signedDate
     */
    public void setSignedDate(Date signedDate) {
        this.signedDate = signedDate;
    }
}
