
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;

/** 
 * An area of land which is a sub-division within a country, such as a state, a county, a canton, a province, etc.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CountrySubDivisionType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:CountryType" name="Country" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CountrySubDivisionCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CountrySubDivisionName" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CountrySubDivisionType implements Serializable
{
    private CountryType country;
    private String countrySubDivisionCode;
    private String countrySubDivisionName;

    /** 
     * Get the 'Country' element value. A nation with its own government, occupying a particular territory.
     * 
     * @return value
     */
    public CountryType getCountry() {
        return country;
    }

    /** 
     * Set the 'Country' element value. A nation with its own government, occupying a particular territory.
     * 
     * @param country
     */
    public void setCountry(CountryType country) {
        this.country = country;
    }

    /** 
     * Get the 'CountrySubDivisionCode' element value. The ISO code identifying this country sub-division within a given country. E.g. 'AZ' for state of Arizona (US), 'BY' for region of Bavaria (Germany).
     * 
     * @return value
     */
    public String getCountrySubDivisionCode() {
        return countrySubDivisionCode;
    }

    /** 
     * Set the 'CountrySubDivisionCode' element value. The ISO code identifying this country sub-division within a given country. E.g. 'AZ' for state of Arizona (US), 'BY' for region of Bavaria (Germany).
     * 
     * @param countrySubDivisionCode
     */
    public void setCountrySubDivisionCode(String countrySubDivisionCode) {
        this.countrySubDivisionCode = countrySubDivisionCode;
    }

    /** 
     * Get the 'CountrySubDivisionName' element value. The name, expressed as text, of the sub-division of a country.
     * 
     * @return value
     */
    public String getCountrySubDivisionName() {
        return countrySubDivisionName;
    }

    /** 
     * Set the 'CountrySubDivisionName' element value. The name, expressed as text, of the sub-division of a country.
     * 
     * @param countrySubDivisionName
     */
    public void setCountrySubDivisionName(String countrySubDivisionName) {
        this.countrySubDivisionName = countrySubDivisionName;
    }
}
