
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * The portion of the Passenger Ticket and Baggage Check or Excess Baggage Ticket that indicates particular places between which the coupon is good for carriage.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CouponType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="BaggageAllowanceRefID" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element type="xs:decimal" name="ConnectedCouponNumber" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="ConsumedAtIssuanceInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CouponMediaTypeCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:decimal" name="CouponNumber" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:decimal" name="CouponRefNumber" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:decimal" name="CouponSeqNumber" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CouponStatusCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CouponValidityPeriodType" name="CouponValidityPeriod" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CurrentCouponFlightInfoType" name="CurrentCouponFlightInfo" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ExcessBaggageType" name="ExcessBaggage" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="FareBasisCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:FiledFeeType" name="FiledFee" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="InvolIndCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="NonCommissionableInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="NonInterlineableInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="NonRefundableInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="NonReissuableNonExchInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:KeyValuePropertyType" name="ProductCharacteristic" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PromotionType" name="Promotion" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="RemarkText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ResChangeInfoType" name="ResChangeInfo" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="RFIC_Code" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="RFISC_Code" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="RFISC_Desc" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:date" name="ServiceDeliveryDate" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ServiceDeliveryProviderLocationCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ServiceDeliveryProviderName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:QtyType" name="ServiceQty" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ServiceRefID" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="SettlementAuthorizationID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PaxSegmentRefType" name="SoldAirlineInfo" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:AmountType" name="ValueAmount" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CouponType implements Serializable
{
    private List<String> baggageAllowanceRefIDList = new ArrayList<String>();
    private BigDecimal connectedCouponNumber;
    private Boolean consumedAtIssuanceInd;
    private String couponMediaTypeCode;
    private BigDecimal couponNumber;
    private BigDecimal couponRefNumber;
    private BigDecimal couponSeqNumber;
    private String couponStatusCode;
    private CouponValidityPeriodType couponValidityPeriod;
    private CurrentCouponFlightInfoType currentCouponFlightInfo;
    private ExcessBaggageType excessBaggage;
    private String fareBasisCode;
    private FiledFeeType filedFee;
    private String involIndCode;
    private Boolean nonCommissionableInd;
    private Boolean nonInterlineableInd;
    private Boolean nonRefundableInd;
    private Boolean nonReissuableNonExchInd;
    private KeyValuePropertyType productCharacteristic;
    private PromotionType promotion;
    private String remarkText;
    private ResChangeInfoType resChangeInfo;
    private String RFICCode;
    private String RFISCCode;
    private String RFISCDesc;
    private Date serviceDeliveryDate;
    private String serviceDeliveryProviderLocationCode;
    private String serviceDeliveryProviderName;
    private QtyType serviceQty;
    private List<String> serviceRefIDList = new ArrayList<String>();
    private String settlementAuthorizationID;
    private PaxSegmentRefType soldAirlineInfo;
    private AmountType valueAmount;

    /** 
     * Get the list of 'BaggageAllowanceRefID' element items. Reference to a BaggageAllowanceID
     * 
     * @return list
     */
    public List<String> getBaggageAllowanceRefIDList() {
        return baggageAllowanceRefIDList;
    }

    /** 
     * Set the list of 'BaggageAllowanceRefID' element items. Reference to a BaggageAllowanceID
     * 
     * @param list
     */
    public void setBaggageAllowanceRefIDList(List<String> list) {
        baggageAllowanceRefIDList = list;
    }

    /** 
     * Get the 'ConnectedCouponNumber' element value. The coupon number to which this document is connected.
     * 
     * @return value
     */
    public BigDecimal getConnectedCouponNumber() {
        return connectedCouponNumber;
    }

    /** 
     * Set the 'ConnectedCouponNumber' element value. The coupon number to which this document is connected.
     * 
     * @param connectedCouponNumber
     */
    public void setConnectedCouponNumber(BigDecimal connectedCouponNumber) {
        this.connectedCouponNumber = connectedCouponNumber;
    }

    /** 
     * Get the 'ConsumedAtIssuanceInd' element value. When TRUE, the coupon is consumed at issuance.
     * 
     * @return value
     */
    public Boolean getConsumedAtIssuanceInd() {
        return consumedAtIssuanceInd;
    }

    /** 
     * Set the 'ConsumedAtIssuanceInd' element value. When TRUE, the coupon is consumed at issuance.
     * 
     * @param consumedAtIssuanceInd
     */
    public void setConsumedAtIssuanceInd(Boolean consumedAtIssuanceInd) {
        this.consumedAtIssuanceInd = consumedAtIssuanceInd;
    }

    /** 
     * Get the 'CouponMediaTypeCode' element value. Type of media used to issue the coupon (e.g. Electronic, Paper, Other).
     * 
     * @return value
     */
    public String getCouponMediaTypeCode() {
        return couponMediaTypeCode;
    }

    /** 
     * Set the 'CouponMediaTypeCode' element value. Type of media used to issue the coupon (e.g. Electronic, Paper, Other).
     * 
     * @param couponMediaTypeCode
     */
    public void setCouponMediaTypeCode(String couponMediaTypeCode) {
        this.couponMediaTypeCode = couponMediaTypeCode;
    }

    /** 
     * Get the 'CouponNumber' element value. Number assigned to the issued coupon.
     * 
     * @return value
     */
    public BigDecimal getCouponNumber() {
        return couponNumber;
    }

    /** 
     * Set the 'CouponNumber' element value. Number assigned to the issued coupon.
     * 
     * @param couponNumber
     */
    public void setCouponNumber(BigDecimal couponNumber) {
        this.couponNumber = couponNumber;
    }

    /** 
     * Get the 'CouponRefNumber' element value. The sequential number (segment identifier) of an individual flight segment.
     * 
     * @return value
     */
    public BigDecimal getCouponRefNumber() {
        return couponRefNumber;
    }

    /** 
     * Set the 'CouponRefNumber' element value. The sequential number (segment identifier) of an individual flight segment.
     * 
     * @param couponRefNumber
     */
    public void setCouponRefNumber(BigDecimal couponRefNumber) {
        this.couponRefNumber = couponRefNumber;
    }

    /** 
     * Get the 'CouponSeqNumber' element value. The number representing the order in which this coupon was used or is to be used.
     * 
     * @return value
     */
    public BigDecimal getCouponSeqNumber() {
        return couponSeqNumber;
    }

    /** 
     * Set the 'CouponSeqNumber' element value. The number representing the order in which this coupon was used or is to be used.
     * 
     * @param couponSeqNumber
     */
    public void setCouponSeqNumber(BigDecimal couponSeqNumber) {
        this.couponSeqNumber = couponSeqNumber;
    }

    /** 
     * Get the 'CouponStatusCode' element value. Current status of the flight/ value coupon.  Example: E (Exchanged/Reissued)
     * 
     * @return value
     */
    public String getCouponStatusCode() {
        return couponStatusCode;
    }

    /** 
     * Set the 'CouponStatusCode' element value. Current status of the flight/ value coupon.  Example: E (Exchanged/Reissued)
     * 
     * @param couponStatusCode
     */
    public void setCouponStatusCode(String couponStatusCode) {
        this.couponStatusCode = couponStatusCode;
    }

    /** 
     * Get the 'CouponValidityPeriod' element value. Date range a coupon is valid for with an optional time component.
     * 
     * @return value
     */
    public CouponValidityPeriodType getCouponValidityPeriod() {
        return couponValidityPeriod;
    }

    /** 
     * Set the 'CouponValidityPeriod' element value. Date range a coupon is valid for with an optional time component.
     * 
     * @param couponValidityPeriod
     */
    public void setCouponValidityPeriod(
            CouponValidityPeriodType couponValidityPeriod) {
        this.couponValidityPeriod = couponValidityPeriod;
    }

    /** 
     * Get the 'CurrentCouponFlightInfo' element value. Latest flight information as it relates to a coupon (e.g. Current, CheckedIn, Flown).
     * 
     * @return value
     */
    public CurrentCouponFlightInfoType getCurrentCouponFlightInfo() {
        return currentCouponFlightInfo;
    }

    /** 
     * Set the 'CurrentCouponFlightInfo' element value. Latest flight information as it relates to a coupon (e.g. Current, CheckedIn, Flown).
     * 
     * @param currentCouponFlightInfo
     */
    public void setCurrentCouponFlightInfo(
            CurrentCouponFlightInfoType currentCouponFlightInfo) {
        this.currentCouponFlightInfo = currentCouponFlightInfo;
    }

    /** 
     * Get the 'ExcessBaggage' element value. Excess baggage information displayed on a coupon.
     * 
     * @return value
     */
    public ExcessBaggageType getExcessBaggage() {
        return excessBaggage;
    }

    /** 
     * Set the 'ExcessBaggage' element value. Excess baggage information displayed on a coupon.
     * 
     * @param excessBaggage
     */
    public void setExcessBaggage(ExcessBaggageType excessBaggage) {
        this.excessBaggage = excessBaggage;
    }

    /** 
     * Get the 'FareBasisCode' element value. Fare basis code as ticketed. Example: Y26
     * 
     * @return value
     */
    public String getFareBasisCode() {
        return fareBasisCode;
    }

    /** 
     * Set the 'FareBasisCode' element value. Fare basis code as ticketed. Example: Y26
     * 
     * @param fareBasisCode
     */
    public void setFareBasisCode(String fareBasisCode) {
        this.fareBasisCode = fareBasisCode;
    }

    /** 
     * Get the 'FiledFee' element value. Filed fee information relating to a coupon, including the Bankers Seller Rate used to convert the filed amount into the currency of payment.
     * 
     * @return value
     */
    public FiledFeeType getFiledFee() {
        return filedFee;
    }

    /** 
     * Set the 'FiledFee' element value. Filed fee information relating to a coupon, including the Bankers Seller Rate used to convert the filed amount into the currency of payment.
     * 
     * @param filedFee
     */
    public void setFiledFee(FiledFeeType filedFee) {
        this.filedFee = filedFee;
    }

    /** 
     * Get the 'InvolIndCode' element value. Involuntary charge transaction code. Example: I (Involuntary - no reason given).
     * 
     * @return value
     */
    public String getInvolIndCode() {
        return involIndCode;
    }

    /** 
     * Set the 'InvolIndCode' element value. Involuntary charge transaction code. Example: I (Involuntary - no reason given).
     * 
     * @param involIndCode
     */
    public void setInvolIndCode(String involIndCode) {
        this.involIndCode = involIndCode;
    }

    /** 
     * Get the 'NonCommissionableInd' element value. When TRUE, the document is non-commissionable.
     * 
     * @return value
     */
    public Boolean getNonCommissionableInd() {
        return nonCommissionableInd;
    }

    /** 
     * Set the 'NonCommissionableInd' element value. When TRUE, the document is non-commissionable.
     * 
     * @param nonCommissionableInd
     */
    public void setNonCommissionableInd(Boolean nonCommissionableInd) {
        this.nonCommissionableInd = nonCommissionableInd;
    }

    /** 
     * Get the 'NonInterlineableInd' element value. When TRUE, the document is non-interlineable.
     * 
     * @return value
     */
    public Boolean getNonInterlineableInd() {
        return nonInterlineableInd;
    }

    /** 
     * Set the 'NonInterlineableInd' element value. When TRUE, the document is non-interlineable.
     * 
     * @param nonInterlineableInd
     */
    public void setNonInterlineableInd(Boolean nonInterlineableInd) {
        this.nonInterlineableInd = nonInterlineableInd;
    }

    /** 
     * Get the 'NonRefundableInd' element value. When TRUE, the fare is non refundable.
     * 
     * @return value
     */
    public Boolean getNonRefundableInd() {
        return nonRefundableInd;
    }

    /** 
     * Set the 'NonRefundableInd' element value. When TRUE, the fare is non refundable.
     * 
     * @param nonRefundableInd
     */
    public void setNonRefundableInd(Boolean nonRefundableInd) {
        this.nonRefundableInd = nonRefundableInd;
    }

    /** 
     * Get the 'NonReissuableNonExchInd' element value. When TRUE, the document is non-reissuable and/or exchangeable.
     * 
     * @return value
     */
    public Boolean getNonReissuableNonExchInd() {
        return nonReissuableNonExchInd;
    }

    /** 
     * Set the 'NonReissuableNonExchInd' element value. When TRUE, the document is non-reissuable and/or exchangeable.
     * 
     * @param nonReissuableNonExchInd
     */
    public void setNonReissuableNonExchInd(Boolean nonReissuableNonExchInd) {
        this.nonReissuableNonExchInd = nonReissuableNonExchInd;
    }

    /** 
     * Get the 'ProductCharacteristic' element value. Contains product characteristics of an optional service, for inclusion on EMD. The type (Designates an optional service product characteristic type e.g., t-shirt size, color or pre-reserved seat number) should be carried in the Key field and characteristic value (Text that describes the product sold for the corresponding Product Characteristic Type, e.g. large, blue.) should be passed in the value field.
     * 
     * @return value
     */
    public KeyValuePropertyType getProductCharacteristic() {
        return productCharacteristic;
    }

    /** 
     * Set the 'ProductCharacteristic' element value. Contains product characteristics of an optional service, for inclusion on EMD. The type (Designates an optional service product characteristic type e.g., t-shirt size, color or pre-reserved seat number) should be carried in the Key field and characteristic value (Text that describes the product sold for the corresponding Product Characteristic Type, e.g. large, blue.) should be passed in the value field.
     * 
     * @param productCharacteristic
     */
    public void setProductCharacteristic(
            KeyValuePropertyType productCharacteristic) {
        this.productCharacteristic = productCharacteristic;
    }

    /** 
     * Get the 'Promotion' element value. Information related to publicizing  a product, organization, or venture so as to increase sales or public awareness.
     * 
     * @return value
     */
    public PromotionType getPromotion() {
        return promotion;
    }

    /** 
     * Set the 'Promotion' element value. Information related to publicizing  a product, organization, or venture so as to increase sales or public awareness.
     * 
     * @param promotion
     */
    public void setPromotion(PromotionType promotion) {
        this.promotion = promotion;
    }

    /** 
     * Get the 'RemarkText' element value. Free text to provide further information related to the document and/or coupon.
     * 
     * @return value
     */
    public String getRemarkText() {
        return remarkText;
    }

    /** 
     * Set the 'RemarkText' element value. Free text to provide further information related to the document and/or coupon.
     * 
     * @param remarkText
     */
    public void setRemarkText(String remarkText) {
        this.remarkText = remarkText;
    }

    /** 
     * Get the 'ResChangeInfo' element value. Reservation change information which describes new flight information as it relates to a changed reservation.
     * 
     * @return value
     */
    public ResChangeInfoType getResChangeInfo() {
        return resChangeInfo;
    }

    /** 
     * Set the 'ResChangeInfo' element value. Reservation change information which describes new flight information as it relates to a changed reservation.
     * 
     * @param resChangeInfo
     */
    public void setResChangeInfo(ResChangeInfoType resChangeInfo) {
        this.resChangeInfo = resChangeInfo;
    }

    /** 
     * Get the 'RFIC_Code' element value. Reason For Issuance Code  Examples: A (Air Transportation) C (Baggage) E (Airport Services) F (Merchandise) G (In-flight Services)
     * 
     * @return value
     */
    public String getRFICCode() {
        return RFICCode;
    }

    /** 
     * Set the 'RFIC_Code' element value. Reason For Issuance Code  Examples: A (Air Transportation) C (Baggage) E (Airport Services) F (Merchandise) G (In-flight Services)
     * 
     * @param RFICCode
     */
    public void setRFICCode(String RFICCode) {
        this.RFICCode = RFICCode;
    }

    /** 
     * Get the 'RFISC_Code' element value. Reason For Issuance Sub Code. Examples: 0CC (First Checked Bag) 0B1 (In-flight Entertainment) 0BX (Lounge)
     * 
     * @return value
     */
    public String getRFISCCode() {
        return RFISCCode;
    }

    /** 
     * Set the 'RFISC_Code' element value. Reason For Issuance Sub Code. Examples: 0CC (First Checked Bag) 0B1 (In-flight Entertainment) 0BX (Lounge)
     * 
     * @param RFISCCode
     */
    public void setRFISCCode(String RFISCCode) {
        this.RFISCCode = RFISCCode;
    }

    /** 
     * Get the 'RFISC_Desc' element value. Corresponding description for the Reason for Issuance subcode.
     * 
     * @return value
     */
    public String getRFISCDesc() {
        return RFISCDesc;
    }

    /** 
     * Set the 'RFISC_Desc' element value. Corresponding description for the Reason for Issuance subcode.
     * 
     * @param RFISCDesc
     */
    public void setRFISCDesc(String RFISCDesc) {
        this.RFISCDesc = RFISCDesc;
    }

    /** 
     * Get the 'ServiceDeliveryDate' element value. The date that the associated service to this Coupon should be delivered.
     * 
     * @return value
     */
    public Date getServiceDeliveryDate() {
        return serviceDeliveryDate;
    }

    /** 
     * Set the 'ServiceDeliveryDate' element value. The date that the associated service to this Coupon should be delivered.
     * 
     * @param serviceDeliveryDate
     */
    public void setServiceDeliveryDate(Date serviceDeliveryDate) {
        this.serviceDeliveryDate = serviceDeliveryDate;
    }

    /** 
     * Get the 'ServiceDeliveryProviderLocationCode' element value. The name of the service provider who will perform the service as described on an EMD coupon.
     * 
     * @return value
     */
    public String getServiceDeliveryProviderLocationCode() {
        return serviceDeliveryProviderLocationCode;
    }

    /** 
     * Set the 'ServiceDeliveryProviderLocationCode' element value. The name of the service provider who will perform the service as described on an EMD coupon.
     * 
     * @param serviceDeliveryProviderLocationCode
     */
    public void setServiceDeliveryProviderLocationCode(
            String serviceDeliveryProviderLocationCode) {
        this.serviceDeliveryProviderLocationCode = serviceDeliveryProviderLocationCode;
    }

    /** 
     * Get the 'ServiceDeliveryProviderName' element value. The name of the service provider who will perform the service as described on an EMD coupon.
     * 
     * @return value
     */
    public String getServiceDeliveryProviderName() {
        return serviceDeliveryProviderName;
    }

    /** 
     * Set the 'ServiceDeliveryProviderName' element value. The name of the service provider who will perform the service as described on an EMD coupon.
     * 
     * @param serviceDeliveryProviderName
     */
    public void setServiceDeliveryProviderName(
            String serviceDeliveryProviderName) {
        this.serviceDeliveryProviderName = serviceDeliveryProviderName;
    }

    /** 
     * Get the 'ServiceQty' element value. Number of services of the same type that are included in an EMD coupon.
     * 
     * @return value
     */
    public QtyType getServiceQty() {
        return serviceQty;
    }

    /** 
     * Set the 'ServiceQty' element value. Number of services of the same type that are included in an EMD coupon.
     * 
     * @param serviceQty
     */
    public void setServiceQty(QtyType serviceQty) {
        this.serviceQty = serviceQty;
    }

    /** 
     * Get the list of 'ServiceRefID' element items. Reference to a Service ID
     * 
     * @return list
     */
    public List<String> getServiceRefIDList() {
        return serviceRefIDList;
    }

    /** 
     * Set the list of 'ServiceRefID' element items. Reference to a Service ID
     * 
     * @param list
     */
    public void setServiceRefIDList(List<String> list) {
        serviceRefIDList = list;
    }

    /** 
     * Get the 'SettlementAuthorizationID' element value. A reference ID generated by the validating carrier authorizing settlement of a coupon.  Example: AUTH123
     * 
     * @return value
     */
    public String getSettlementAuthorizationID() {
        return settlementAuthorizationID;
    }

    /** 
     * Set the 'SettlementAuthorizationID' element value. A reference ID generated by the validating carrier authorizing settlement of a coupon.  Example: AUTH123
     * 
     * @param settlementAuthorizationID
     */
    public void setSettlementAuthorizationID(String settlementAuthorizationID) {
        this.settlementAuthorizationID = settlementAuthorizationID;
    }

    /** 
     * Get the 'SoldAirlineInfo' element value. Transportation of a passenger on a Dated Operating Segment.
     * 
     * @return value
     */
    public PaxSegmentRefType getSoldAirlineInfo() {
        return soldAirlineInfo;
    }

    /** 
     * Set the 'SoldAirlineInfo' element value. Transportation of a passenger on a Dated Operating Segment.
     * 
     * @param soldAirlineInfo
     */
    public void setSoldAirlineInfo(PaxSegmentRefType soldAirlineInfo) {
        this.soldAirlineInfo = soldAirlineInfo;
    }

    /** 
     * Get the 'ValueAmount' element value. The value associated to a single coupon of a miscellaneous document (e.g. 100 USD).
     * 
     * @return value
     */
    public AmountType getValueAmount() {
        return valueAmount;
    }

    /** 
     * Set the 'ValueAmount' element value. The value associated to a single coupon of a miscellaneous document (e.g. 100 USD).
     * 
     * @param valueAmount
     */
    public void setValueAmount(AmountType valueAmount) {
        this.valueAmount = valueAmount;
    }
}
