
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;
import java.sql.Date;

/** 
 * Date range a coupon is valid for with an optional time component.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CouponValidityPeriodType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Duration" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:date" name="EffectiveDate" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:date" name="ExpirationDate" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CouponValidityPeriodType implements Serializable
{
    private String duration;
    private Date effectiveDate;
    private Date expirationDate;

    /** 
     * Get the 'Duration' element value. Effective period duration.  Ex: P3M.  This may be used in combination with the effective date, versus specifying an expiration date.
     * 
     * @return value
     */
    public String getDuration() {
        return duration;
    }

    /** 
     * Set the 'Duration' element value. Effective period duration.  Ex: P3M.  This may be used in combination with the effective date, versus specifying an expiration date.
     * 
     * @param duration
     */
    public void setDuration(String duration) {
        this.duration = duration;
    }

    /** 
     * Get the 'EffectiveDate' element value. Start date for when a coupon is valid.
     * 
     * @return value
     */
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    /** 
     * Set the 'EffectiveDate' element value. Start date for when a coupon is valid.
     * 
     * @param effectiveDate
     */
    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    /** 
     * Get the 'ExpirationDate' element value. End date for when a coupon is valid.
     * 
     * @return value
     */
    public Date getExpirationDate() {
        return expirationDate;
    }

    /** 
     * Set the 'ExpirationDate' element value. End date for when a coupon is valid.
     * 
     * @param expirationDate
     */
    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }
}
