
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;

/** 
 * Form of identification.  Typically used to identify that the passenger is who he says he is.  This is the type of FOID as defined in AIRIMP (FF Number, Credit Card Number, etc.).
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FOID_Type">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CreditCardIssuerCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="FOID_ID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="FOID_TypeText" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FOIDType implements Serializable
{
    private String creditCardIssuerCode;
    private String FOIDID;
    private String FOIDTypeText;

    /** 
     * Get the 'CreditCardIssuerCode' element value. The CC Issuer code in case FOID is a Credit Card.
     * 
     * @return value
     */
    public String getCreditCardIssuerCode() {
        return creditCardIssuerCode;
    }

    /** 
     * Set the 'CreditCardIssuerCode' element value. The CC Issuer code in case FOID is a Credit Card.
     * 
     * @param creditCardIssuerCode
     */
    public void setCreditCardIssuerCode(String creditCardIssuerCode) {
        this.creditCardIssuerCode = creditCardIssuerCode;
    }

    /** 
     * Get the 'FOID_ID' element value. FOID ID value. Example: NY122345
     * 
     * @return value
     */
    public String getFOIDID() {
        return FOIDID;
    }

    /** 
     * Set the 'FOID_ID' element value. FOID ID value. Example: NY122345
     * 
     * @param FOIDID
     */
    public void setFOIDID(String FOIDID) {
        this.FOIDID = FOIDID;
    }

    /** 
     * Get the 'FOID_TypeText' element value. Form of identification type code used for booking/ticketing.  Examples: PP (passport), CC (credit card), FF (frequent flyer), DL (drivers license)
     * 
     * @return value
     */
    public String getFOIDTypeText() {
        return FOIDTypeText;
    }

    /** 
     * Set the 'FOID_TypeText' element value. Form of identification type code used for booking/ticketing.  Examples: PP (passport), CC (credit card), FF (frequent flyer), DL (drivers license)
     * 
     * @param FOIDTypeText
     */
    public void setFOIDTypeText(String FOIDTypeText) {
        this.FOIDTypeText = FOIDTypeText;
    }
}
