
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;

/** 
 * Filed fee information relating to a coupon, including the Bankers Seller Rate used to convert the filed amount into the currency of payment.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FiledFeeType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:RateType" name="BankersSellerRate" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:AmountType" name="FeeAmount" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FiledFeeType implements Serializable
{
    private RateType bankersSellerRate;
    private AmountType feeAmount;

    /** 
     * Get the 'BankersSellerRate' element value. The BSR or BBR used to convert the filed fee amount from the filed currency into the currency of payment.
     * 
     * @return value
     */
    public RateType getBankersSellerRate() {
        return bankersSellerRate;
    }

    /** 
     * Set the 'BankersSellerRate' element value. The BSR or BBR used to convert the filed fee amount from the filed currency into the currency of payment.
     * 
     * @param bankersSellerRate
     */
    public void setBankersSellerRate(RateType bankersSellerRate) {
        this.bankersSellerRate = bankersSellerRate;
    }

    /** 
     * Get the 'FeeAmount' element value. File fee amount. Example: 100 USD.
     * 
     * @return value
     */
    public AmountType getFeeAmount() {
        return feeAmount;
    }

    /** 
     * Set the 'FeeAmount' element value. File fee amount. Example: 100 USD.
     * 
     * @param feeAmount
     */
    public void setFeeAmount(AmountType feeAmount) {
        this.feeAmount = feeAmount;
    }
}
