
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Eligiibility of this offer item to the following segments or journeys.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightAssociationsType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="xs:string" name="DatedOperatingLegRefID" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="PaxJourneyRefID" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="PaxSegmentRefID" maxOccurs="unbounded"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FlightAssociationsType implements Serializable
{
    private int choiceSelect = -1;
    private static final int DATED_OPERATING_LEG_REF_ID_LIST_CHOICE = 0;
    private static final int PAX_JOURNEY_REF_ID_LIST_CHOICE = 1;
    private static final int PAX_SEGMENT_REF_ID_LIST_CHOICE = 2;
    private List<String> datedOperatingLegRefIDList = new ArrayList<String>();
    private List<String> paxJourneyRefIDList = new ArrayList<String>();
    private List<String> paxSegmentRefIDList = new ArrayList<String>();

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if DatedOperatingLegRefIDList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDatedOperatingLegRefIDList() {
        return choiceSelect == DATED_OPERATING_LEG_REF_ID_LIST_CHOICE;
    }

    /** 
     * Get the list of 'DatedOperatingLegRefID' element items. Reference to the Dated Operating Legs.
     * 
     * @return list
     */
    public List<String> getDatedOperatingLegRefIDList() {
        return datedOperatingLegRefIDList;
    }

    /** 
     * Set the list of 'DatedOperatingLegRefID' element items. Reference to the Dated Operating Legs.
     * 
     * @param list
     */
    public void setDatedOperatingLegRefIDList(List<String> list) {
        setChoiceSelect(DATED_OPERATING_LEG_REF_ID_LIST_CHOICE);
        datedOperatingLegRefIDList = list;
    }

    /** 
     * Check if PaxJourneyRefIDList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPaxJourneyRefIDList() {
        return choiceSelect == PAX_JOURNEY_REF_ID_LIST_CHOICE;
    }

    /** 
     * Get the list of 'PaxJourneyRefID' element items. Reference to the journeys for which this Offer Item can be provided.
     * 
     * @return list
     */
    public List<String> getPaxJourneyRefIDList() {
        return paxJourneyRefIDList;
    }

    /** 
     * Set the list of 'PaxJourneyRefID' element items. Reference to the journeys for which this Offer Item can be provided.
     * 
     * @param list
     */
    public void setPaxJourneyRefIDList(List<String> list) {
        setChoiceSelect(PAX_JOURNEY_REF_ID_LIST_CHOICE);
        paxJourneyRefIDList = list;
    }

    /** 
     * Check if PaxSegmentRefIDList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPaxSegmentRefIDList() {
        return choiceSelect == PAX_SEGMENT_REF_ID_LIST_CHOICE;
    }

    /** 
     * Get the list of 'PaxSegmentRefID' element items. Reference to the flight segments on which this Offer Item can be provided.
     * 
     * @return list
     */
    public List<String> getPaxSegmentRefIDList() {
        return paxSegmentRefIDList;
    }

    /** 
     * Set the list of 'PaxSegmentRefID' element items. Reference to the flight segments on which this Offer Item can be provided.
     * 
     * @param list
     */
    public void setPaxSegmentRefIDList(List<String> list) {
        setChoiceSelect(PAX_SEGMENT_REF_ID_LIST_CHOICE);
        paxSegmentRefIDList = list;
    }
}
