
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;

/** 
 * Information related to the value of a product or service as it pertains to interline transactions.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InterlineSettlementInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="MethodCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:AmountType" name="SettlementAmount" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="TaxableInd" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class InterlineSettlementInfoType implements Serializable
{
    private String methodCode;
    private AmountType settlementAmount;
    private Boolean taxableInd;

    /** 
     * Get the 'MethodCode' element value. Settlement method. Examples: - AD (Internal Airline Document) - DS (Direct Settlement) - EA (EMD Associated or Internal Airline Document).
     * 
     * @return value
     */
    public String getMethodCode() {
        return methodCode;
    }

    /** 
     * Set the 'MethodCode' element value. Settlement method. Examples: - AD (Internal Airline Document) - DS (Direct Settlement) - EA (EMD Associated or Internal Airline Document).
     * 
     * @param methodCode
     */
    public void setMethodCode(String methodCode) {
        this.methodCode = methodCode;
    }

    /** 
     * Get the 'SettlementAmount' element value. Settlement (Price) Value. Example: 300 (USD) Note: This represents a Settlement value that is only used between the POA and ORA.
     * 
     * @return value
     */
    public AmountType getSettlementAmount() {
        return settlementAmount;
    }

    /** 
     * Set the 'SettlementAmount' element value. Settlement (Price) Value. Example: 300 (USD) Note: This represents a Settlement value that is only used between the POA and ORA.
     * 
     * @param settlementAmount
     */
    public void setSettlementAmount(AmountType settlementAmount) {
        this.settlementAmount = settlementAmount;
    }

    /** 
     * Get the 'TaxableInd' element value. In some markets, commission is VAT-able (i.e. Taxable)
     * 
     * @return value
     */
    public Boolean getTaxableInd() {
        return taxableInd;
    }

    /** 
     * Set the 'TaxableInd' element value. In some markets, commission is VAT-able (i.e. Taxable)
     * 
     * @param taxableInd
     */
    public void setTaxableInd(Boolean taxableInd) {
        this.taxableInd = taxableInd;
    }
}
