
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/** 
 * A form of payment by which the customer uses a virtual currency of a Loyalty Program Account (such as air miles) in exchange for goods or services.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LoyaltyRedemptionType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:decimal" name="CertificateNumber" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:AmountType" name="LoyaltyCurAmount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:LoyaltyProgramAccountType" name="LoyaltyProgramAccount" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class LoyaltyRedemptionType implements Serializable
{
    private List<BigDecimal> certificateNumberList = new ArrayList<BigDecimal>();
    private AmountType loyaltyCurAmount;
    private LoyaltyProgramAccountType loyaltyProgramAccount;

    /** 
     * Get the list of 'CertificateNumber' element items. The loyalty redemption certificate number.
     * 
     * @return list
     */
    public List<BigDecimal> getCertificateNumberList() {
        return certificateNumberList;
    }

    /** 
     * Set the list of 'CertificateNumber' element items. The loyalty redemption certificate number.
     * 
     * @param list
     */
    public void setCertificateNumberList(List<BigDecimal> list) {
        certificateNumberList = list;
    }

    /** 
     * Get the 'LoyaltyCurAmount' element value. The quantity of loyalty units redeemed. Example: 15000
     * 
     * @return value
     */
    public AmountType getLoyaltyCurAmount() {
        return loyaltyCurAmount;
    }

    /** 
     * Set the 'LoyaltyCurAmount' element value. The quantity of loyalty units redeemed. Example: 15000
     * 
     * @param loyaltyCurAmount
     */
    public void setLoyaltyCurAmount(AmountType loyaltyCurAmount) {
        this.loyaltyCurAmount = loyaltyCurAmount;
    }

    /** 
     * Get the 'LoyaltyProgramAccount' element value. An account set up for a customer within a rewards program which holds funds on behalf of that customer.
     * 
     * @return value
     */
    public LoyaltyProgramAccountType getLoyaltyProgramAccount() {
        return loyaltyProgramAccount;
    }

    /** 
     * Set the 'LoyaltyProgramAccount' element value. An account set up for a customer within a rewards program which holds funds on behalf of that customer.
     * 
     * @param loyaltyProgramAccount
     */
    public void setLoyaltyProgramAccount(
            LoyaltyProgramAccountType loyaltyProgramAccount) {
        this.loyaltyProgramAccount = loyaltyProgramAccount;
    }
}
