
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;

/** 
 * Defines the reason for the markup added by an airline as part of the offer reported as calculation detail.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarkupType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:AmountType" name="Amount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TypeCode" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class MarkupType implements Serializable
{
    private AmountType amount;
    private String typeCode;

    /** 
     * Get the 'Amount' element value. Value &amp; sold-in currency added by an airline as part of the offer reported as calculation detail.
     * 
     * @return value
     */
    public AmountType getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. Value &amp; sold-in currency added by an airline as part of the offer reported as calculation detail.
     * 
     * @param amount
     */
    public void setAmount(AmountType amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'TypeCode' element value. Defines the reason for the markup added by an airline as part of the offer reported as calculation detail.  (Examples: currency markup, service markup, etcâ€¦)
     * 
     * @return value
     */
    public String getTypeCode() {
        return typeCode;
    }

    /** 
     * Set the 'TypeCode' element value. Defines the reason for the markup added by an airline as part of the offer reported as calculation detail.  (Examples: currency markup, service markup, etcâ€¦)
     * 
     * @param typeCode
     */
    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }
}
