
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;

/** 
 * Enumeration set for the measurement system code BDT. {codeListAgencyName}PADIS{/codeListAgencyName}
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MeasurementSystemCodeContentType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Imperial"/>
 *     &lt;xs:enumeration value="Metric"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum MeasurementSystemCodeContentType implements Serializable {
    IMPERIAL("Imperial"), METRIC("Metric");
    private final String value;

    private MeasurementSystemCodeContentType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static MeasurementSystemCodeContentType convert(String value) {
        for (MeasurementSystemCodeContentType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
