
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * An individually priced item within an Order, made up of one or more Services. May or may not be a selected Offer Item (e.g. non-chargeable Services available on request such as a wheelchair).
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderItemType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:BilateralTimeLimitType" name="BilateralTimeLimit" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:DateTimeType" name="CreationDateTime" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DateTimeType" name="DepositTimeLimitDateTime" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="DisclosureRefID" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:FareDetailType" name="FareDetail" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:DateTimeType" name="NamingTimeLimitDateTime" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OrderInstructionType" name="OrderInstruction" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="OrderItemID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OwnerCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OwnerTypeCodeContentType" name="OwnerTypeCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DateTimeType" name="PaymentTimeLimitDateTime" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PenaltyRefID" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:PriceType" name="Price" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DateTimeType" name="PriceGuaranteeTimeLimitDateTime" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ServiceType" name="Service" minOccurs="1" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:OrderItemStatusCodeContentType" name="StatusCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="WebAddressURI" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OrderItemType implements Serializable
{
    private List<BilateralTimeLimitType> bilateralTimeLimitList = new ArrayList<BilateralTimeLimitType>();
    private DateTimeType creationDateTime;
    private DateTimeType depositTimeLimitDateTime;
    private List<String> disclosureRefIDList = new ArrayList<String>();
    private List<FareDetailType> fareDetailList = new ArrayList<FareDetailType>();
    private DateTimeType namingTimeLimitDateTime;
    private List<OrderInstructionType> orderInstructionList = new ArrayList<OrderInstructionType>();
    private String orderItemID;
    private String ownerCode;
    private OwnerTypeCodeContentType ownerTypeCode;
    private DateTimeType paymentTimeLimitDateTime;
    private List<String> penaltyRefIDList = new ArrayList<String>();
    private PriceType price;
    private DateTimeType priceGuaranteeTimeLimitDateTime;
    private List<ServiceType> serviceList = new ArrayList<ServiceType>();
    private OrderItemStatusCodeContentType statusCode;
    private String webAddressURI;

    /** 
     * Get the list of 'BilateralTimeLimit' element items. A bilaterally agreed limitation or restriction of time.
     * 
     * @return list
     */
    public List<BilateralTimeLimitType> getBilateralTimeLimitList() {
        return bilateralTimeLimitList;
    }

    /** 
     * Set the list of 'BilateralTimeLimit' element items. A bilaterally agreed limitation or restriction of time.
     * 
     * @param list
     */
    public void setBilateralTimeLimitList(List<BilateralTimeLimitType> list) {
        bilateralTimeLimitList = list;
    }

    /** 
     * Get the 'CreationDateTime' element value. Order Item creation Timestamp.
     * 
     * @return value
     */
    public DateTimeType getCreationDateTime() {
        return creationDateTime;
    }

    /** 
     * Set the 'CreationDateTime' element value. Order Item creation Timestamp.
     * 
     * @param creationDateTime
     */
    public void setCreationDateTime(DateTimeType creationDateTime) {
        this.creationDateTime = creationDateTime;
    }

    /** 
     * Get the 'DepositTimeLimitDateTime' element value. The date by which a deposit must be paid for an order item. Examples:  2015-01-13T13:59:38Z
     * 
     * @return value
     */
    public DateTimeType getDepositTimeLimitDateTime() {
        return depositTimeLimitDateTime;
    }

    /** 
     * Set the 'DepositTimeLimitDateTime' element value. The date by which a deposit must be paid for an order item. Examples:  2015-01-13T13:59:38Z
     * 
     * @param depositTimeLimitDateTime
     */
    public void setDepositTimeLimitDateTime(
            DateTimeType depositTimeLimitDateTime) {
        this.depositTimeLimitDateTime = depositTimeLimitDateTime;
    }

    /** 
     * Get the list of 'DisclosureRefID' element items. References a Disclosure ID.
     * 
     * @return list
     */
    public List<String> getDisclosureRefIDList() {
        return disclosureRefIDList;
    }

    /** 
     * Set the list of 'DisclosureRefID' element items. References a Disclosure ID.
     * 
     * @param list
     */
    public void setDisclosureRefIDList(List<String> list) {
        disclosureRefIDList = list;
    }

    /** 
     * Get the list of 'FareDetail' element items. The amount charged by the carrier for the carriage of a passenger and his allowable free baggage.
     * 
     * @return list
     */
    public List<FareDetailType> getFareDetailList() {
        return fareDetailList;
    }

    /** 
     * Set the list of 'FareDetail' element items. The amount charged by the carrier for the carriage of a passenger and his allowable free baggage.
     * 
     * @param list
     */
    public void setFareDetailList(List<FareDetailType> list) {
        fareDetailList = list;
    }

    /** 
     * Get the 'NamingTimeLimitDateTime' element value. The time by which an Order Item must be completed with individual passenger names. Examples: 2015-01-13T13:59:38Z
     * 
     * @return value
     */
    public DateTimeType getNamingTimeLimitDateTime() {
        return namingTimeLimitDateTime;
    }

    /** 
     * Set the 'NamingTimeLimitDateTime' element value. The time by which an Order Item must be completed with individual passenger names. Examples: 2015-01-13T13:59:38Z
     * 
     * @param namingTimeLimitDateTime
     */
    public void setNamingTimeLimitDateTime(DateTimeType namingTimeLimitDateTime) {
        this.namingTimeLimitDateTime = namingTimeLimitDateTime;
    }

    /** 
     * Get the list of 'OrderInstruction' element items. Special service information
     * 
     * @return list
     */
    public List<OrderInstructionType> getOrderInstructionList() {
        return orderInstructionList;
    }

    /** 
     * Set the list of 'OrderInstruction' element items. Special service information
     * 
     * @param list
     */
    public void setOrderInstructionList(List<OrderInstructionType> list) {
        orderInstructionList = list;
    }

    /** 
     * Get the 'OrderItemID' element value. Carrier assigned ID which exists uniquely within an Order.
     * 
     * @return value
     */
    public String getOrderItemID() {
        return orderItemID;
    }

    /** 
     * Set the 'OrderItemID' element value. Carrier assigned ID which exists uniquely within an Order.
     * 
     * @param orderItemID
     */
    public void setOrderItemID(String orderItemID) {
        this.orderItemID = orderItemID;
    }

    /** 
     * Get the 'OwnerCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @return value
     */
    public String getOwnerCode() {
        return ownerCode;
    }

    /** 
     * Set the 'OwnerCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @param ownerCode
     */
    public void setOwnerCode(String ownerCode) {
        this.ownerCode = ownerCode;
    }

    /** 
     * Get the 'OwnerTypeCode' element value. Indicates whether or not the owner is the ORA or POA.
     * 
     * @return value
     */
    public OwnerTypeCodeContentType getOwnerTypeCode() {
        return ownerTypeCode;
    }

    /** 
     * Set the 'OwnerTypeCode' element value. Indicates whether or not the owner is the ORA or POA.
     * 
     * @param ownerTypeCode
     */
    public void setOwnerTypeCode(OwnerTypeCodeContentType ownerTypeCode) {
        this.ownerTypeCode = ownerTypeCode;
    }

    /** 
     * Get the 'PaymentTimeLimitDateTime' element value. The time limit by which a commitment to pay must be made for the given Order Item. Upon expiry it is expected that the Order item is removed from the Order.  If no value is returned, then no advice has been given.  For example:  PaymentTimeLimitDateTime: 2015-01-01T12:53:12Z - indicates the date time by which payment commitment is required.
     * 
     * @return value
     */
    public DateTimeType getPaymentTimeLimitDateTime() {
        return paymentTimeLimitDateTime;
    }

    /** 
     * Set the 'PaymentTimeLimitDateTime' element value. The time limit by which a commitment to pay must be made for the given Order Item. Upon expiry it is expected that the Order item is removed from the Order.  If no value is returned, then no advice has been given.  For example:  PaymentTimeLimitDateTime: 2015-01-01T12:53:12Z - indicates the date time by which payment commitment is required.
     * 
     * @param paymentTimeLimitDateTime
     */
    public void setPaymentTimeLimitDateTime(
            DateTimeType paymentTimeLimitDateTime) {
        this.paymentTimeLimitDateTime = paymentTimeLimitDateTime;
    }

    /** 
     * Get the list of 'PenaltyRefID' element items. Reference to a Penalty ID.
     * 
     * @return list
     */
    public List<String> getPenaltyRefIDList() {
        return penaltyRefIDList;
    }

    /** 
     * Set the list of 'PenaltyRefID' element items. Reference to a Penalty ID.
     * 
     * @param list
     */
    public void setPenaltyRefIDList(List<String> list) {
        penaltyRefIDList = list;
    }

    /** 
     * Get the 'Price' element value. The amount of money expected, required, or given in payment for something.
     * 
     * @return value
     */
    public PriceType getPrice() {
        return price;
    }

    /** 
     * Set the 'Price' element value. The amount of money expected, required, or given in payment for something.
     * 
     * @param price
     */
    public void setPrice(PriceType price) {
        this.price = price;
    }

    /** 
     * Get the 'PriceGuaranteeTimeLimitDateTime' element value. The length of time the price of an Order Item is guaranteed.  In the absence of the price guarantee time limit, the price is not guaranteed. Upon expiry, the price may no longer be guaranteed and either the Order should be repriced, which may result in a new RepricedOffer, or a new shopping process may begin.
     * 
     * @return value
     */
    public DateTimeType getPriceGuaranteeTimeLimitDateTime() {
        return priceGuaranteeTimeLimitDateTime;
    }

    /** 
     * Set the 'PriceGuaranteeTimeLimitDateTime' element value. The length of time the price of an Order Item is guaranteed.  In the absence of the price guarantee time limit, the price is not guaranteed. Upon expiry, the price may no longer be guaranteed and either the Order should be repriced, which may result in a new RepricedOffer, or a new shopping process may begin.
     * 
     * @param priceGuaranteeTimeLimitDateTime
     */
    public void setPriceGuaranteeTimeLimitDateTime(
            DateTimeType priceGuaranteeTimeLimitDateTime) {
        this.priceGuaranteeTimeLimitDateTime = priceGuaranteeTimeLimitDateTime;
    }

    /** 
     * Get the list of 'Service' element items. The instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order.
     * 
     * @return list
     */
    public List<ServiceType> getServiceList() {
        return serviceList;
    }

    /** 
     * Set the list of 'Service' element items. The instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order.
     * 
     * @param list
     */
    public void setServiceList(List<ServiceType> list) {
        serviceList = list;
    }

    /** 
     * Get the 'StatusCode' element value. Indicates the current status of an Order Item.
     * 
     * @return value
     */
    public OrderItemStatusCodeContentType getStatusCode() {
        return statusCode;
    }

    /** 
     * Set the 'StatusCode' element value. Indicates the current status of an Order Item.
     * 
     * @param statusCode
     */
    public void setStatusCode(OrderItemStatusCodeContentType statusCode) {
        this.statusCode = statusCode;
    }

    /** 
     * Get the 'WebAddressURI' element value. Deep linking into another site to complete the transaction. E.g. to bring the customer directly to a page to continue with a purchase of a specific offer.
     * 
     * @return value
     */
    public String getWebAddressURI() {
        return webAddressURI;
    }

    /** 
     * Set the 'WebAddressURI' element value. Deep linking into another site to complete the transaction. E.g. to bring the customer directly to a page to continue with a purchase of a specific offer.
     * 
     * @param webAddressURI
     */
    public void setWebAddressURI(String webAddressURI) {
        this.webAddressURI = webAddressURI;
    }
}
