
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Associated order information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderRefType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="OrderID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OrderItemID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OwnerCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OwnerTypeCodeContentType" name="OwnerTypeCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ServiceID" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="WebAddressURI" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OrderRefType implements Serializable
{
    private String orderID;
    private String orderItemID;
    private String ownerCode;
    private OwnerTypeCodeContentType ownerTypeCode;
    private List<String> serviceIDList = new ArrayList<String>();
    private String webAddressURI;

    /** 
     * Get the 'OrderID' element value. Carrier assigned ID which uniquely identifies a specific Order across several messages.
     * 
     * @return value
     */
    public String getOrderID() {
        return orderID;
    }

    /** 
     * Set the 'OrderID' element value. Carrier assigned ID which uniquely identifies a specific Order across several messages.
     * 
     * @param orderID
     */
    public void setOrderID(String orderID) {
        this.orderID = orderID;
    }

    /** 
     * Get the 'OrderItemID' element value. Carrier assigned ID which exists uniquely within an Order.
     * 
     * @return value
     */
    public String getOrderItemID() {
        return orderItemID;
    }

    /** 
     * Set the 'OrderItemID' element value. Carrier assigned ID which exists uniquely within an Order.
     * 
     * @param orderItemID
     */
    public void setOrderItemID(String orderItemID) {
        this.orderItemID = orderItemID;
    }

    /** 
     * Get the 'OwnerCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @return value
     */
    public String getOwnerCode() {
        return ownerCode;
    }

    /** 
     * Set the 'OwnerCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @param ownerCode
     */
    public void setOwnerCode(String ownerCode) {
        this.ownerCode = ownerCode;
    }

    /** 
     * Get the 'OwnerTypeCode' element value. Indicates whether the owner is the ORA or POA.
     * 
     * @return value
     */
    public OwnerTypeCodeContentType getOwnerTypeCode() {
        return ownerTypeCode;
    }

    /** 
     * Set the 'OwnerTypeCode' element value. Indicates whether the owner is the ORA or POA.
     * 
     * @param ownerTypeCode
     */
    public void setOwnerTypeCode(OwnerTypeCodeContentType ownerTypeCode) {
        this.ownerTypeCode = ownerTypeCode;
    }

    /** 
     * Get the list of 'ServiceID' element items. Uniquely Identifies a Service within the context of one message.
     * 
     * @return list
     */
    public List<String> getServiceIDList() {
        return serviceIDList;
    }

    /** 
     * Set the list of 'ServiceID' element items. Uniquely Identifies a Service within the context of one message.
     * 
     * @param list
     */
    public void setServiceIDList(List<String> list) {
        serviceIDList = list;
    }

    /** 
     * Get the 'WebAddressURI' element value. Deep linking into another site to complete the transaction. E.g. to bring the customer directly to a page to continue with a purchase of a specific offer.
     * 
     * @return value
     */
    public String getWebAddressURI() {
        return webAddressURI;
    }

    /** 
     * Set the 'WebAddressURI' element value. Deep linking into another site to complete the transaction. E.g. to bring the customer directly to a page to continue with a purchase of a specific offer.
     * 
     * @param webAddressURI
     */
    public void setWebAddressURI(String webAddressURI) {
        this.webAddressURI = webAddressURI;
    }
}
