
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a flexible range of airline products and services that are not necessarily Journey based (e.g. subscription services).
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:BilateralTimeLimitType" name="BilateralTimeLimit" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:BookingRefType" name="BookingRef" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:DateTimeType" name="CreationDateTime" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DateTimeType" name="DepositTimeLimitDateTime" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DateTimeType" name="LastModifiedDateTime" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DateTimeType" name="NamingTimeLimitDateTime" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OrderID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OrderItemType" name="OrderItem" minOccurs="1" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:Order1Type" name="OrderKeys" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:OriginalOrderType" name="OriginalOrder" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OwnerCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OwnerTypeCodeContentType" name="OwnerTypeCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PaxGroupType" name="PaxGroup" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OrderStatusCodeContentType" name="StatusCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PriceType" name="TotalPrice" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="WebAddressURI" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OrderType implements Serializable
{
    private List<BilateralTimeLimitType> bilateralTimeLimitList = new ArrayList<BilateralTimeLimitType>();
    private List<BookingRefType> bookingRefList = new ArrayList<BookingRefType>();
    private DateTimeType creationDateTime;
    private DateTimeType depositTimeLimitDateTime;
    private DateTimeType lastModifiedDateTime;
    private DateTimeType namingTimeLimitDateTime;
    private String orderID;
    private List<OrderItemType> orderItemList = new ArrayList<OrderItemType>();
    private List<Order1Type> orderKeyList = new ArrayList<Order1Type>();
    private OriginalOrderType originalOrder;
    private String ownerCode;
    private OwnerTypeCodeContentType ownerTypeCode;
    private PaxGroupType paxGroup;
    private OrderStatusCodeContentType statusCode;
    private PriceType totalPrice;
    private String webAddressURI;

    /** 
     * Get the list of 'BilateralTimeLimit' element items. A bilaterally agreed limitation or restriction of time.
     * 
     * @return list
     */
    public List<BilateralTimeLimitType> getBilateralTimeLimitList() {
        return bilateralTimeLimitList;
    }

    /** 
     * Set the list of 'BilateralTimeLimit' element items. A bilaterally agreed limitation or restriction of time.
     * 
     * @param list
     */
    public void setBilateralTimeLimitList(List<BilateralTimeLimitType> list) {
        bilateralTimeLimitList = list;
    }

    /** 
     * Get the list of 'BookingRef' element items. Information related to a booking or reservation.
     * 
     * @return list
     */
    public List<BookingRefType> getBookingRefList() {
        return bookingRefList;
    }

    /** 
     * Set the list of 'BookingRef' element items. Information related to a booking or reservation.
     * 
     * @param list
     */
    public void setBookingRefList(List<BookingRefType> list) {
        bookingRefList = list;
    }

    /** 
     * Get the 'CreationDateTime' element value. The date time by which the order is created. Examples: 2018-09-05T15:52:01Z
     * 
     * @return value
     */
    public DateTimeType getCreationDateTime() {
        return creationDateTime;
    }

    /** 
     * Set the 'CreationDateTime' element value. The date time by which the order is created. Examples: 2018-09-05T15:52:01Z
     * 
     * @param creationDateTime
     */
    public void setCreationDateTime(DateTimeType creationDateTime) {
        this.creationDateTime = creationDateTime;
    }

    /** 
     * Get the 'DepositTimeLimitDateTime' element value. The date by which a deposit must be paid for an order Examples:  2015-01-13T13:59:38Z
     * 
     * @return value
     */
    public DateTimeType getDepositTimeLimitDateTime() {
        return depositTimeLimitDateTime;
    }

    /** 
     * Set the 'DepositTimeLimitDateTime' element value. The date by which a deposit must be paid for an order Examples:  2015-01-13T13:59:38Z
     * 
     * @param depositTimeLimitDateTime
     */
    public void setDepositTimeLimitDateTime(
            DateTimeType depositTimeLimitDateTime) {
        this.depositTimeLimitDateTime = depositTimeLimitDateTime;
    }

    /** 
     * Get the 'LastModifiedDateTime' element value. The date time by which the order is modified. Examples: 2018-09-05T15:52:01Z
     * 
     * @return value
     */
    public DateTimeType getLastModifiedDateTime() {
        return lastModifiedDateTime;
    }

    /** 
     * Set the 'LastModifiedDateTime' element value. The date time by which the order is modified. Examples: 2018-09-05T15:52:01Z
     * 
     * @param lastModifiedDateTime
     */
    public void setLastModifiedDateTime(DateTimeType lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
    }

    /** 
     * Get the 'NamingTimeLimitDateTime' element value. The time by which an Order must be completed with individual passenger names. Examples: 2015-01-13T13:59:38Z
     * 
     * @return value
     */
    public DateTimeType getNamingTimeLimitDateTime() {
        return namingTimeLimitDateTime;
    }

    /** 
     * Set the 'NamingTimeLimitDateTime' element value. The time by which an Order must be completed with individual passenger names. Examples: 2015-01-13T13:59:38Z
     * 
     * @param namingTimeLimitDateTime
     */
    public void setNamingTimeLimitDateTime(DateTimeType namingTimeLimitDateTime) {
        this.namingTimeLimitDateTime = namingTimeLimitDateTime;
    }

    /** 
     * Get the 'OrderID' element value. Carrier assigned ID which uniquely identifies a specific Order across several messages.
     * 
     * @return value
     */
    public String getOrderID() {
        return orderID;
    }

    /** 
     * Set the 'OrderID' element value. Carrier assigned ID which uniquely identifies a specific Order across several messages.
     * 
     * @param orderID
     */
    public void setOrderID(String orderID) {
        this.orderID = orderID;
    }

    /** 
     * Get the list of 'OrderItem' element items. An individually priced item within an Order, made up of one or more Services. May or may not be a selected Offer Item (e.g. non-chargeable Services available on request such as a wheelchair).
     * 
     * @return list
     */
    public List<OrderItemType> getOrderItemList() {
        return orderItemList;
    }

    /** 
     * Set the list of 'OrderItem' element items. An individually priced item within an Order, made up of one or more Services. May or may not be a selected Offer Item (e.g. non-chargeable Services available on request such as a wheelchair).
     * 
     * @param list
     */
    public void setOrderItemList(List<OrderItemType> list) {
        orderItemList = list;
    }

    /** 
     * Get the list of 'OrderKeys' element items. Order Keys. Contains one Order ID with associated Order Item ID(s).

    Notes: These are Orders that were created from Offers that have already been purchased, booked and/or are being held for a Traveler.
     * 
     * @return list
     */
    public List<Order1Type> getOrderKeyList() {
        return orderKeyList;
    }

    /** 
     * Set the list of 'OrderKeys' element items. Order Keys. Contains one Order ID with associated Order Item ID(s).

    Notes: These are Orders that were created from Offers that have already been purchased, booked and/or are being held for a Traveler.
     * 
     * @param list
     */
    public void setOrderKeyList(List<Order1Type> list) {
        orderKeyList = list;
    }

    /** 
     * Get the 'OriginalOrder' element value. This may be used when an Order has been sub-divided into associated Orders and serves as a reference to the original Order ID.
     * 
     * @return value
     */
    public OriginalOrderType getOriginalOrder() {
        return originalOrder;
    }

    /** 
     * Set the 'OriginalOrder' element value. This may be used when an Order has been sub-divided into associated Orders and serves as a reference to the original Order ID.
     * 
     * @param originalOrder
     */
    public void setOriginalOrder(OriginalOrderType originalOrder) {
        this.originalOrder = originalOrder;
    }

    /** 
     * Get the 'OwnerCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @return value
     */
    public String getOwnerCode() {
        return ownerCode;
    }

    /** 
     * Set the 'OwnerCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @param ownerCode
     */
    public void setOwnerCode(String ownerCode) {
        this.ownerCode = ownerCode;
    }

    /** 
     * Get the 'OwnerTypeCode' element value. Indicates whether the owner is the ORA or POA.
     * 
     * @return value
     */
    public OwnerTypeCodeContentType getOwnerTypeCode() {
        return ownerTypeCode;
    }

    /** 
     * Set the 'OwnerTypeCode' element value. Indicates whether the owner is the ORA or POA.
     * 
     * @param ownerTypeCode
     */
    public void setOwnerTypeCode(OwnerTypeCodeContentType ownerTypeCode) {
        this.ownerTypeCode = ownerTypeCode;
    }

    /** 
     * Get the 'PaxGroup' element value. A number of individual passengers traveling under one commercial name that associates them. E.g. a Tour group or a group for sales allotment from airline to agency.
     * 
     * @return value
     */
    public PaxGroupType getPaxGroup() {
        return paxGroup;
    }

    /** 
     * Set the 'PaxGroup' element value. A number of individual passengers traveling under one commercial name that associates them. E.g. a Tour group or a group for sales allotment from airline to agency.
     * 
     * @param paxGroup
     */
    public void setPaxGroup(PaxGroupType paxGroup) {
        this.paxGroup = paxGroup;
    }

    /** 
     * Get the 'StatusCode' element value. Indicates the current status of an Order E.g. OK (Confirmed)
     * 
     * @return value
     */
    public OrderStatusCodeContentType getStatusCode() {
        return statusCode;
    }

    /** 
     * Set the 'StatusCode' element value. Indicates the current status of an Order E.g. OK (Confirmed)
     * 
     * @param statusCode
     */
    public void setStatusCode(OrderStatusCodeContentType statusCode) {
        this.statusCode = statusCode;
    }

    /** 
     * Get the 'TotalPrice' element value. The amount of money expected, required, or given in payment for something.
     * 
     * @return value
     */
    public PriceType getTotalPrice() {
        return totalPrice;
    }

    /** 
     * Set the 'TotalPrice' element value. The amount of money expected, required, or given in payment for something.
     * 
     * @param totalPrice
     */
    public void setTotalPrice(PriceType totalPrice) {
        this.totalPrice = totalPrice;
    }

    /** 
     * Get the 'WebAddressURI' element value. Deep linking into another site to complete the transaction. E.g. to bring the customer directly to a page to continue with a purchase of a specific offer.
     * 
     * @return value
     */
    public String getWebAddressURI() {
        return webAddressURI;
    }

    /** 
     * Set the 'WebAddressURI' element value. Deep linking into another site to complete the transaction. E.g. to bring the customer directly to a page to continue with a purchase of a specific offer.
     * 
     * @param webAddressURI
     */
    public void setWebAddressURI(String webAddressURI) {
        this.webAddressURI = webAddressURI;
    }
}
